/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.notification;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.comalatech.confluence.adhoc.notification.WorkflowNotificationConfigManager;
import com.comalatech.confluence.adhoc.notification.model.NotificationType;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.stats.WorkflowStatisticsManager;
import org.springframework.beans.factory.annotation.Qualifier;

public class NotificationConfigAction
extends ConfluenceActionSupport {
    protected WorkflowNotificationConfigManager workflowNotificationConfigManager;
    private AdhocWorkflowsLicenseManager licenseManager;
    private WorkflowStatisticsManager workflowStatisticsManager;
    private WorkflowsFeatureManager workflowsFeatureManager;
    boolean taskAssigned;
    boolean taskPageWatcher;
    boolean approvalAssigned;
    boolean stateAssigned;
    boolean stateExpired;
    boolean readConfirmation;
    private String confirm;
    private boolean editMode = true;
    private String docoUrlCDM = "https://apps.appf.re/cdmdc/doc/globalnotifications/56t706";
    private String docoUrlCDC = "https://apps.appf.re/cdcdc/doc/globaladminconfig/vA6VpE";
    private String docoUrlCDA = "https://apps.appf.re/cdadc/doc/adminguide/wW7YjI";

    public String view() {
        this.editMode = false;
        return "success";
    }

    public String edit() {
        return "success";
    }

    public String save() {
        if (this.confirm != null) {
            this.workflowNotificationConfigManager.setNotificationConfig(NotificationType.APPROVAL_ASSIGNMENT, this.approvalAssigned);
            this.workflowNotificationConfigManager.setNotificationConfig(NotificationType.READ_CONFIRMATION, this.readConfirmation);
            if (this.workflowsFeatureManager.isApprovalsApp()) {
                return "success";
            }
            this.workflowNotificationConfigManager.setNotificationConfig(NotificationType.STATE_EXPIRED, this.stateExpired);
            if (this.workflowsFeatureManager.isWorkflowsLiteApp()) {
                return "success";
            }
            this.workflowNotificationConfigManager.setNotificationConfig(NotificationType.TASK_ASSIGNMENT, this.taskAssigned);
            this.workflowNotificationConfigManager.setNotificationConfig(NotificationType.STATE_ASSIGNMENT, this.stateAssigned);
            this.workflowNotificationConfigManager.setNotificationConfig(NotificationType.TASK_PAGEWATCHER, this.taskPageWatcher);
        }
        return "success";
    }

    public boolean getNotificationConfig(String notificationName) {
        return this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.getByName(notificationName));
    }

    public String getWorkflowLicenseMessageHtml() {
        return this.licenseManager.getLicenseStatus().getMessageHtml();
    }

    public void setWorkflowNotificationConfigManager(WorkflowNotificationConfigManager workflowNotificationConfigManager) {
        this.workflowNotificationConfigManager = workflowNotificationConfigManager;
    }

    public void setLicenseManager(@Qualifier(value="adhocWorkflowsLicenseManager") AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setTaskAssigned(boolean taskAssigned) {
        this.taskAssigned = taskAssigned;
    }

    public void setApprovalAssigned(boolean approvalAssigned) {
        this.approvalAssigned = approvalAssigned;
    }

    public void setStateAssigned(boolean stateAssigned) {
        this.stateAssigned = stateAssigned;
    }

    public void setTaskPageWatcher(boolean taskPageWatcher) {
        this.taskPageWatcher = taskPageWatcher;
    }

    public void setStateExpired(boolean stateExpired) {
        this.stateExpired = stateExpired;
    }

    public void setReadConfirmation(boolean readConfirmation) {
        this.readConfirmation = readConfirmation;
    }

    public WorkflowStatisticsManager getWorkflowStatisticsManager() {
        return this.workflowStatisticsManager;
    }

    public void setWorkflowStatisticsManager(WorkflowStatisticsManager workflowStatisticsManager) {
        this.workflowStatisticsManager = workflowStatisticsManager;
    }

    public void setWorkflowsFeatureManager(WorkflowsFeatureManager workflowsFeatureManager) {
        this.workflowsFeatureManager = workflowsFeatureManager;
    }

    public String getDocoUrl(String app) {
        String url = this.docoUrlCDM;
        if (app.equalsIgnoreCase("cda")) {
            url = this.docoUrlCDA;
        } else if (app.equalsIgnoreCase("cdc")) {
            url = this.docoUrlCDC;
        }
        return url;
    }
}

