/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

/**
 * #Message
 */
var AWP = AWP || {};
AWP.View = AWP.View || {};
AWP.View.Message = Backbone.View.extend({
    // backbone prop
    className: "awp-slide awp-slide-inactive",
    
    // custom prop
    options: {
        title: '',
        description: '',
        closeable: false,
        type: 'warning',
        disabled: true
    },
    template : AWP.Templates.message,
    
    initialize: function (op) {
        AJS.$.extend(true, op, this.options);
    },
    
    render: function() {
        var optionsMessages = {
            closeable: this.options.closeable,
            shadowed: true
        };

        this.$el.append(this.template({
            disabled: this.options.disabled
        }));
       
        // load message component
        switch(this.options.type) {
            case 'error':
                AJS.messages.error(this.$('.awp-message'), optionsMessages);
            break;
            case 'success':
                AJS.messages.success(this.$('.awp-message'), optionsMessages);
            break;
            case 'warning':
            default:
                AJS.messages.warning(this.$('.awp-message'), optionsMessages);
        }

        // Instead inserting message to the component above
        // append message to component this way, so the link is not escaped
        this.$('.aui-message .title strong').html(this.options.title);
        if(this.options.description != '') {
            this.$('.aui-message').append(AJS.$('<p></p>').html(this.options.description));
            
        }
        return this.el;
    }
});