
/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

Adhoc = Adhoc || {};

Adhoc.Tasks = Adhoc.Tasks || {};

(function ($) {

    Adhoc.Tasks.clickedTasksId;
    Adhoc.Tasks.editDialog,
    Adhoc.Tasks.dialog,
    Adhoc.Tasks.dialogOptions = {
            width: 280,
            offsetY: 17,
            offsetX: -40,
            hideDelay: 10000
    };
    Adhoc.Tasks.editDialogOptions = {
        width:480,
        height: 400,
        id:"inline-dialog-adhocTasks",
        closeOnOutsideClick: true
    };


    Adhoc.Tasks.hideDialog = function() {
        if (Adhoc.Tasks.dialog && Adhoc.Tasks.dialog != undefined) {
            Adhoc.Tasks.dialog.hide();
        }
        if (Adhoc.Tasks.editDialog && Adhoc.Tasks.editDialog != undefined ) {
            Adhoc.Tasks.editDialog.hide();
        }
        return false;
    };

    Adhoc.Tasks.isInlineDialog = function() {
        return $("#inline-dialog-adhocTasks").hasClass("aui-inline-dialog");
    };

    Adhoc.Tasks.getSelectedText = function() {
        var sel;
        if (jQuery.browser.msie) {
            sel = document.selection.createRange().text;
        } else {
            sel = window.getSelection();
        }
        sel = "" + sel;
        if (sel && sel.length > 2 && sel.indexOf("'") != 0 && sel.indexOf('"') != 0 && sel.indexOf("|") < 0 && sel.indexOf('"') < 0) {
            sel = "" + sel;
            return sel.split("\n",10);
        } else {
            return [];
        }
    };

    Adhoc.Tasks.getNames = function($form) {
        var names = [];
        $form.find("input.taskName:not(.placeholded)").each(function() {
            var val = $(this).val();
            if (val.length > 0) {
                names.push(val);
            }
        });
        return names;
    };

    Adhoc.Tasks.doAction = function() {
        var $form = $(this).parents("form");
        var action = $(this).attr("name");
        var taskId = $form.find("input[name='id']").val();
        var taskRequest = {
            names: Adhoc.Tasks.getNames($form),
            assignee: Adhoc.getAssignees($form),
            note: $form.find("textarea:not(.placeholded)").val()
        };
        Adhoc.submitProgress($(this).parents(".adhoc"));
        $.ajax({
            type: "POST",
            cache: false,
            contentType: "application/json; charset=utf-8",
            url: AJS.Confluence.getContextPath() + "/rest/adhocworkflows/latest/tasks/" + AJS.params.pageId + "/"
                    + (taskId != undefined && taskId > 0 ? taskId + "/" : "")
                    + action,
            data: JSON.stringify(taskRequest),
            success: function (data, textStatus, jqXHR) {
                if (jqXHR.status == 200) {
                    Adhoc.Tasks.tasks = data.tasks;
                    Adhoc.Tasks.updateCount(data.tasks.length);
                    var $contents;
                    if (Adhoc.Tasks.isInlineDialog()) {
                        $contents = Adhoc.Tasks.dialog.find(".contents");
                    } else {
                        $contents = $("#inline-dialog-adhocTasks .editor-task-dialog");
                    }
                    Adhoc.Tasks.doDialog(data.tasks,$contents,true);
                    if (! Adhoc.Tasks.isInlineDialog()) {
                        Adhoc.Tasks.editDialog.show();
                    }
                } else {
                    Adhoc.Tasks.hideDialog();
                }
            },
            error: Adhoc.errorHandler
        });
        return false;
    };

    Adhoc.Tasks.hideTask = function() {
        $(".adhoc .task").removeClass("active");
        return false;
    }

    Adhoc.Tasks.showTask = function() {
        if (AJS.dropDown.current != undefined) {
            AJS.dropDown.current.hide();
        }
        $("#inline-dialog-adhocTasks form.addtask").removeClass("active");
        var $task = $(this).parents(".task");
        var action = $(this).attr("name");
        if (action == undefined || action == "") {
            action = $(this).find("a").attr("name");
        }
        var $form = $task.find("form");
        $task.find(".cancel-task").click();
        $task.addClass("active");
        $form.attr("class","aui").addClass(action);
        return false;
    }

    Adhoc.Tasks.updateCount = function(count) {
        $("#adhocTasksLink span, #rte-button-adhoctasks span.trigger-text").html("");
        var templateName;
        if (count == undefined) {
            count = 0;
        }
        if (count == 0) {
            templateName = "adhoctasks-tasks-count0";
        } else if (count == 1) {
            $("#adhocTasksLink").css("display","block");
            templateName = "adhoctasks-tasks-count1";
        } else {
            $("#adhocTasksLink").css("display","block");
            templateName = "adhoctasks-tasks-count";
        }
        $("#adhocTasksLink span, #rte-button-adhoctasks span.trigger-text").append(AJS.template.load(templateName).fill({count: count}));
    };

    Adhoc.Tasks.toggleAddTask = function() {
        Adhoc.Tasks.hideTask();
        $("#inline-dialog-adhocTasks form.addtask").toggleClass("active");
        $("#taskName0").click().focus();
        return false;
    };

    Adhoc.Tasks.assign = function() {
        var $this= $(this);
        var $form = $(this).parents(".task").find("form");
        $form.addClass("assign");
        $form.removeClass("complete");
        $form.removeClass("view");
        $form.removeClass("remove");
        return false;
    };

    Adhoc.Tasks.remove = function() {
        var $this= $(this);
        var $form = $(this).parents(".task").find("form");
        $form.addClass("remove");
        $form.removeClass("complete");
        $form.removeClass("view");
        $form.removeClass("assign");
        return false;
    };

    Adhoc.Tasks.assignNewTask = function() {
        var $this= $(this);
        var $form = $this.parents("form");
        $form.addClass("assign");
        $this.hide();
        return false;
    };

    Adhoc.Tasks.initClipboardSelection = function ($contents, tasks) {
        var selected;
        if (! $contents.hasClass("reload")) {
            selected = Adhoc.Tasks.getSelectedText();
        } else {
            selected = [];
        }
        Adhoc.selected = selected;
        if (! $("#adhocTasksLink").hasClass("addtasklink") && (tasks.length == 0 || selected.length > 0)) {
            $contents.find("a.add-task").click();
            var index = 0;
            for (var ix = 0; ix < selected.length; ix++) {
                var name = $.trim(selected[ix]);
                if (name.length > 0) {
                    var $input = $("#taskName" + index++);
                    $input.addClass("active").click().val(name);
                }
            }
            if (index > 1) {
                $("form.addtask").addClass("multiple");
            } else {
                $("form.addtask").addClass("single");
            }
        } else {
            $("form.addtask").addClass("single");
        }
    }

    Adhoc.Tasks.doDialog = function(tasks, $contents, reload) {
        var fillTask = function($contents, task, even) {
            task.toggle = even ? "even" : "";
            $contents.find(".tasks").append(AJS.template.load("adhoctasks-task").fill(task));
            var $task = $("#task-" + task.id);
            try {
                $task.find(".task-caption").append(AJS.template.load("adhoctasks-task-completed").fill(task));
            } catch (e) {
                // remove after atlassian fixes CONF-23672
                alert("Comala Workflows panel out of sync because of CONF-23672. Please restart server")
            }
            if (! task.comment || task.comment.length == 0) {
                $task.find(".task-caption .note").remove();
            }
            var $taskCaption = $task.find(".name");
            if (task.actions && task.actions.length > 0) {
                $taskCaption.append(AJS.template.load("adhoctasks-task-action-default").fill({
                    hint: task.hint,
                    action: task.actions[0],
                    shortName: task.shortName,
                    name: task.name}));
            } else {
                $taskCaption.append(task.name);
            }
            if (task.assignee) {
                if (Adhoc.Tasks.isInlineDialog()) {
                    var $assignees = $task.find("ol.assignees.select");
                    Adhoc.addAssignee($assignees, task.assignee.name, task.assignee.fullName, task.assignee.pictureUrl, "assigned");
                } else {
                    $taskCaption.append(AJS.template.load("adhoctasks-task-assignee").fill(task));
                }
            }
            if(task.dueDate){
                $taskCaption.append(AJS.template.load("adhoctasks-task-duedate").fill(task));
            }
            for (var j = task.actions.length - 1; j >= 0; j--) {
                $task.find(".task-header .workflow-actions").append(AJS.template.load("adhoc-action").fill(task.actions[j]));
            }
        };
        $contents.empty();
        if (reload) {
            $contents.addClass("reload");
        }
        Adhoc.Tasks.tasks = tasks;
        $contents.append(AJS.template.load("adhoctasks-tasks").fill());
        for (var i = 0; i < tasks.length; i++) {
            fillTask($contents, tasks[i], i % 2 == 1);
        }
        $contents.find("a.cancel-dialog").click(Adhoc.Tasks.hideDialog);
        $contents.find("a.cancel-addtask, a.add-task").click(Adhoc.Tasks.toggleAddTask);
        $contents.find("input[type='submit']").click(Adhoc.Tasks.doAction);

        $contents.find(".task-header, li.dropdown-item .workflow-action").click(Adhoc.Tasks.showTask);
        $contents.find(".cancel-task").click(Adhoc.Tasks.hideTask);

        $contents.find(".workflow-actions").dropDown("Standard"); // task actions
        Adhoc.Tasks.initClipboardSelection($contents, tasks);
        $contents.find(".assign-new-task").click(Adhoc.Tasks.assignNewTask);
        $contents.find(".assign").click(Adhoc.Tasks.assign);
        $contents.find(".remove").click(Adhoc.Tasks.remove);
        $.ajax({
            type: "GET",
            cache: false,
            url: AJS.Confluence.getContextPath() + "/rest/adhocworkflows/latest/tasks/" + AJS.params.pageId + "/users",
            success: function (data, textStatus, jqXHR) {
                Adhoc.setPresetUsers($(".adhoc .usersdropdown .aui-dropdown"), data.users);
                if (! AJS.$.browser.msie) {
                    $contents.find("input.autocomplete-user").click(function() {
                        var $form = $(this).parents("form");
                        $form.find(".usersdropdown a.aui-dd-trigger").click();
                    });
                }
                $contents.find(".usersdropdown").dropDown("Standard");
            },
            error: Adhoc.errorHandler
        });
        $contents.find("input.autocomplete-user").bind("selected.autocomplete-user", Adhoc.selectAssignee);
        AJS.Confluence.Binder.autocompleteUser();
        if (Adhoc.Tasks.clickedTasksId && Adhoc.Tasks.clickedTasksId > 0) {
            $("#task-" + Adhoc.Tasks.clickedTasksId + " .task-header .name a").click();
            Adhoc.Tasks.clickedTasksId = 0;
        }
        if ($("#adhocTasksLink").hasClass("addtasklink")) {
            $("#adhocTasksLink").removeClass("addtasklink");
            $contents.find("a.add-task").click();
        }
        // Don't use AJS.params as they don't get reloaded when the taskable status changes
        if($("#taskable").val() == "false"){
            $("a.add-task").hide();
        }
    };

    Adhoc.Tasks.generateTasksPopup = function($contents, trigger, doShowPopup) {
        $contents.addClass("adhoc");
        $contents.empty();
        $contents.append(AJS.template.load("adhocworkflows-loading").fill());
        doShowPopup();
        var progressSpinner = Raphael.spinner($contents.find(".progress-messages-icon")[0], 7, "#666");
        $.ajax({
            type: "GET",
            cache: false,
            url: AJS.Confluence.getContextPath() + "/rest/adhocworkflows/latest/tasks/" + AJS.params.pageId,
            success: function (data, textStatus, jqXHR) {
                Adhoc.Tasks.tasks = data.tasks;
                Adhoc.Tasks.updateCount(data.tasks.length);
                Adhoc.Tasks.doDialog(Adhoc.Tasks.tasks,$contents,false);
            },
            error: Adhoc.errorHandler
        });
    };

    Adhoc.Tasks.addTaskLink = function() {
        if($("#taskable").val() != "false"){
            $("#adhocTasksLink").css("display","block").addClass("addtasklink").click();
        }
        return false;
    };

    AJS.toInit(function ($) {
        try {
            Adhoc.Tasks.clickedTasksId = Adhoc.getUrlParams()["task"];
        } catch (e) {}
        if ($("#editor-container, #rte-toolbar").length == 0) {
            Adhoc.Tasks.dialog = AJS.InlineDialog($("#adhocTasksLink"), "adhocTasks", Adhoc.Tasks.generateTasksPopup, Adhoc.Tasks.dialogOptions);
            if ($("#adhocTasksLink").length == 0) {
                return;
            }
        } else if (AJS.params.pageId > 0) {
            Adhoc.Tasks.editDialog = new AJS.Dialog(Adhoc.Tasks.editDialogOptions);
            Adhoc.Tasks.editDialog.addPage("editor-task-dialog").addHeader(AJS.params.tasksLabel);
            /*
            // Deprecated: replaced by the new awp dialog
            // see workflow.js 
            $("#rte-button-adhoctasks").click(function () {
                $("#inline-dialog-adhocTasks").css("height","auto");
                $("#inline-dialog-adhocTasks .dialog-page-menu").remove();
                Adhoc.Tasks.generateTasksPopup($("#inline-dialog-adhocTasks .editor-task-dialog"),this,function() {});
                Adhoc.Tasks.editDialog.show();
                return false;
            });
             */
        } else {
            $("#rte-button-adhoctasks").hide();
        }
        if(AJS.params.pageId > 0 && (AJS.params.contentType == "blogpost" || AJS.params.contentType == "page")){
            try {
                $.ajax({
                    type: "GET",
                    cache: false,
                    url: AJS.Confluence.getContextPath() + "/rest/adhocworkflows/latest/tasks/" + AJS.params.pageId + "/count",
                    success: function (data, textStatus, jqXHR) {
                        Adhoc.Tasks.updateCount(data);
                        if (Adhoc.Tasks.clickedTasksId && Adhoc.Tasks.clickedTasksId > 0) {
                            $("#adhocTasksLink").click();
                        }
                    }
                });
            } catch (e) {
            }
        }
    });
})(AJS.$);
