/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro.parameter.mappers;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.comalatech.confluence.workflowreports.macro.parameter.ReportParameter;
import com.comalatech.confluence.workflowreports.macro.parameter.StateReportParameters;
import com.comalatech.confluence.workflowreports.macro.parameter.StringReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.ParameterMapper;
import com.opensymphony.util.TextUtils;

public class ParentPageParameterMapper
implements ParameterMapper {
    private PageManager pageManager;
    private AbstractPage currentPage;

    public ParentPageParameterMapper(PageManager pageManager, AbstractPage page) {
        this.pageManager = pageManager;
        this.currentPage = page;
    }

    @Override
    public ReportParameter map(ReportParameter parameter) {
        StringReportParameterValue value;
        String parentTitle;
        if (this.parameterCanBeMapped(parameter) && TextUtils.stringSet((String)(parentTitle = (value = (StringReportParameterValue)parameter.getValue()).getValueOrDefault()))) {
            String pageSpaceKey = this.currentPage != null ? this.currentPage.getSpaceKey() : "";
            String pageTitle = parentTitle;
            String[] pageInSpaceFormatTokens = pageTitle.split(":");
            if (pageInSpaceFormatTokens.length > 1) {
                pageSpaceKey = pageInSpaceFormatTokens[0];
                pageTitle = pageInSpaceFormatTokens[1];
            }
            String pageId = "";
            Page page = this.pageManager.getPage(pageSpaceKey, pageTitle);
            if (page != null) {
                pageId = page.getIdAsString();
            }
            parameter.setValue(new StringReportParameterValue(pageId, (String)value.getDefaultValue()));
        }
        return parameter;
    }

    @Override
    public boolean parameterCanBeMapped(ReportParameter parameter) {
        return parameter.keyIs(StateReportParameters.PARENT_PAGE.getKey()) && parameter.getValue() instanceof StringReportParameterValue;
    }
}

