/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.renderer;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.components.EmbeddedRendererComponent;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishedEmbeddedRendererComponent
extends EmbeddedRendererComponent {
    private static final Logger log = LoggerFactory.getLogger(PublishedEmbeddedRendererComponent.class);
    private final AttachmentManager attachmentManager;
    private final WikiStyleRenderer wikiStyleRenderer;
    protected int buildNumber;

    public PublishedEmbeddedRendererComponent(AttachmentManager attachmentManager, WikiStyleRenderer wikiStyleRenderer) {
        this.attachmentManager = attachmentManager;
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.buildNumber = Integer.parseInt(GeneralUtil.getBuildNumber());
    }

    public boolean shouldRender(RenderMode renderMode) {
        return this.buildNumber >= 2148 && renderMode.renderImages();
    }

    public String render(String wiki, RenderContext context) {
        if (!wiki.contains("!")) {
            return wiki;
        }
        if (context.getParam((Object)"releaseview") == null) {
            return wiki;
        }
        return super.render(wiki, context);
    }

    public void appendSubstitution(StringBuffer buffer, RenderContext context, Matcher matcher) {
        String matchStr;
        block4: {
            matchStr = matcher.group(2);
            if (matchStr.length() < 5 || matchStr.charAt(0) == ')') {
                buffer.append("!").append(matchStr).append("!");
                return;
            }
            try {
                int version;
                ContentEntityObject ceo;
                Attachment attachment;
                ApprovalCheck publishedCheck = (ApprovalCheck)context.getParam((Object)"releaseview");
                if (publishedCheck != null && (attachment = this.getAttachment(matchStr, ceo = ((PageContext)context).getEntity())) != null && (version = publishedCheck.getAttachmentVersion(attachment.getId())) != 0 && version != attachment.getVersion()) {
                    String wiki = "{embed:" + matchStr + "|version=" + version + "}";
                    PageContext pageContext = ceo.toPageContext();
                    pageContext.pushRenderMode(RenderMode.suppress((long)256L));
                    buffer.append(context.addRenderedContent((Object)this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)pageContext, wiki)));
                    return;
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                log.error("", (Throwable)e);
            }
        }
        buffer.append("!").append(matchStr).append("!");
    }

    private Attachment getAttachment(String reference, ContentEntityObject ceo) {
        StringTokenizer stok = new StringTokenizer(reference, "|");
        String fileName = stok.nextToken();
        return this.attachmentManager.getAttachment((ContentEntityObject)ceo.getLatestVersion(), fileName);
    }
}

