/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.mywork;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PreDestroy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class AdhocInAppDynamicRegistration
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AdhocInAppDynamicRegistration.class);
    private final List<ServiceRegistration> registrations = new ArrayList<ServiceRegistration>();
    private BundleContext bundleContext;

    public void afterPropertiesSet() throws Exception {
        this.bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        log.info("Attempting to register Adhoc In App Notification Services");
        this.register("com.atlassian.mywork.service.RegistrationProvider", "com.comalatech.confluence.workflow.mywork.WorkflowRegistrationProvider", new Class[]{Class.forName("com.atlassian.upm.api.license.PluginLicenseManager")}, this.bundleContext.getService(this.bundleContext.getServiceReference("com.atlassian.upm.api.license.PluginLicenseManager")));
        this.register("com.atlassian.mywork.service.ActionService", "com.comalatech.confluence.workflow.mywork.WorkflowActionService", new Class[0], new Object[0]);
    }

    private void register(String type, String service, Class[] clazz, Object ... args) {
        try {
            Class<?> aClass = this.getClass().getClassLoader().loadClass(service);
            this.registrations.add(this.bundleContext.registerService(type, aClass.getConstructor(clazz).newInstance(args), null));
        }
        catch (NoClassDefFoundError e) {
            log.info("Could not find Notification and Task libraries, not registering Adhoc In App Notification Services");
        }
        catch (Exception e) {
            log.info("Unknown exception, not registering Adhoc In App Notification Services");
            e.printStackTrace();
        }
    }

    @PreDestroy
    public void shutdown() {
        this.unregister();
    }

    public void destroy() throws Exception {
        this.unregister();
    }

    private void unregister() {
        if (!this.registrations.isEmpty()) {
            for (ServiceRegistration registration : this.registrations) {
                registration.unregister();
            }
            this.registrations.clear();
        }
    }
}

