/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.analytics.AnalyticsManager;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.license.PluginLicenseStatus;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.ValueStoreManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.Workflows;
import com.comalatech.confluence.workflow.analytics.usecases.workflowsmarkup.StoreWorkflowsUseCase;
import com.comalatech.confluence.workflow.descriptors.WorkflowModuleDescriptor;
import com.comalatech.confluence.workflow.model.Approval;
import com.comalatech.confluence.workflow.model.TriggerEvents;
import com.comalatech.confluence.workflow.service.ApprovalsSearchService;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.workflow.model.TasksMode;
import com.comalatech.workflow.template.LinkedTemplateManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultWorkflowAccessor
implements WorkflowAccessor,
ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowAccessor.class);
    private ApplicationContext applicationContext;
    private final ValueStoreManager valueStoreManager;
    private final WorkflowConfigurationManager workflowConfigurationManager;
    private final AdhocWorkflowsLicenseManager adhocWorkflowsLicenseManager;
    private final PluginAccessor pluginAccessor;
    private final WikiStyleRenderer wikiStyleRenderer;
    private LinkedTemplateManager linkedTemplateManager;
    private WorkflowContainerManager workflowContainerManager;
    private AdhocWorkflowManager adhocWorkflowManager;
    private ApprovalsSearchService approvalsSearchService;
    private StoreWorkflowsUseCase storeWorkflowsUseCase;
    private AnalyticsManager analyticsManager;

    public DefaultWorkflowAccessor(ValueStoreManager valueStoreManager, WorkflowConfigurationManager workflowConfigurationManager, @Qualifier(value="adhocWorkflowsLicenseManager") AdhocWorkflowsLicenseManager adhocWorkflowsLicenseManager, PluginAccessor pluginAccessor, WikiStyleRenderer wikiStyleRenderer, StoreWorkflowsUseCase storeWorkflowsUseCase) {
        this.valueStoreManager = valueStoreManager;
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.adhocWorkflowsLicenseManager = adhocWorkflowsLicenseManager;
        this.pluginAccessor = pluginAccessor;
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.storeWorkflowsUseCase = storeWorkflowsUseCase;
    }

    public void afterPropertiesSet() throws Exception {
        this.workflowContainerManager = (WorkflowContainerManager)this.applicationContext.getBean("workflowContainerManager", WorkflowContainerManager.class);
        this.adhocWorkflowManager = (AdhocWorkflowManager)this.applicationContext.getBean("adhocWorkflowManager", AdhocWorkflowManager.class);
        this.approvalsSearchService = (ApprovalsSearchService)this.applicationContext.getBean("workflowApprovalSearchService", ApprovalsSearchService.class);
        this.analyticsManager = (AnalyticsManager)this.applicationContext.getBean("analyticsManager", AnalyticsManager.class);
        this.linkedTemplateManager = (LinkedTemplateManager)this.applicationContext.getBean("linkedTemplateManager", LinkedTemplateManager.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public boolean hasWorkflowsOrApprovals(ContentEntityObject ceo) {
        if (!(ceo instanceof AbstractPage)) {
            return false;
        }
        AbstractPage page = (AbstractPage)ceo.getLatestVersion();
        if (this.adhocWorkflowManager.hasWorkflow(page)) {
            return true;
        }
        return this.workflowContainerManager.hasProductionWorkflows(page);
    }

    @Override
    public boolean hasWorkflowsOrApprovals(ContentEntityObject ceo, boolean includeTasksWorkflow) {
        if (includeTasksWorkflow) {
            return this.hasWorkflowsOrApprovals(ceo);
        }
        return this.hasWorkflowsOrApprovals(ceo) && !this.hasHiddenStatesPageWorkflow(ceo);
    }

    @Override
    public boolean hasHiddenStatesPageWorkflow(ContentEntityObject ceo) {
        if (!(ceo instanceof AbstractPage)) {
            return false;
        }
        AbstractPage page = (AbstractPage)ceo.getLatestVersion();
        Workflow workflow = null;
        try {
            workflow = this.adhocWorkflowManager.getPageWorkflow(page);
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        return workflow != null && workflow.isHideStates();
    }

    @Override
    public List<Workflow> getAllWorkflowsForSpace(String spaceKey) {
        return this.workflowContainerManager.getAllProductionWorkflows(spaceKey);
    }

    @Override
    public List<Workflow> getActiveSpaceWorkflows(String spaceKey, List<Label> labels) {
        ArrayList<Workflow> workflows = new ArrayList<Workflow>();
        List<com.comalatech.workflow.model.Workflow> linkedTemplates = this.linkedTemplateManager.getLinkedTemplates(spaceKey);
        for (com.comalatech.workflow.model.Workflow workflow : linkedTemplates) {
            Workflow workflowModel = (Workflow)workflow;
            if (!workflowModel.isActiveForLabels(labels)) continue;
            workflows.add((Workflow)workflow);
        }
        if (this.workflowConfigurationManager.getConfiguration().isSpaceWorkflowsAllowed(spaceKey)) {
            List<Workflow> spaceWorkflows = this.workflowContainerManager.getAllProductionWorkflows(spaceKey);
            for (Workflow workflow : spaceWorkflows) {
                if (!workflow.isActive() || !workflow.isActiveForLabels(labels)) continue;
                workflows.add(workflow);
            }
        }
        return workflows;
    }

    @Override
    public PageWorkflows getPageWorkflows(AbstractPage page) {
        try {
            return this.getWorkflows(page, null);
        }
        catch (WorkflowException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public PageWorkflows getWorkflows(AbstractPage page) throws WorkflowException {
        return this.getWorkflows(page, null);
    }

    @Override
    public PageWorkflows getWorkflows(AbstractPage page, ConfluenceEvent event) throws WorkflowException {
        try {
            PageWorkflows pageWorkflows;
            Workflow pageWorkflow;
            ValueStore valueStore = null;
            if (page == null) {
                page = this.getPageFromEvent(event);
                if (page == null) {
                    return null;
                }
                valueStore = this.valueStoreManager.createValueStore(event, page);
            } else if (event != null) {
                valueStore = this.valueStoreManager.createValueStore(event, page);
            } else if (!page.isLatestVersion()) {
                if (log.isDebugEnabled()) {
                    log.debug("attempted to get workflows on an old version of " + page);
                }
                return null;
            }
            if (page.getId() == 0L || ContentStatus.DRAFT.getValue().equals(page.getContentStatus())) {
                return null;
            }
            if (valueStore == null) {
                valueStore = this.valueStoreManager.createValueStore(page);
            }
            Label label = TriggerEvents.getLabel(event);
            ArrayList<Workflow> workflows = new ArrayList<Workflow>();
            List<com.comalatech.workflow.model.Workflow> unorderedLinkedTemplates = this.linkedTemplateManager.getLinkedTemplates(page.getSpaceKey());
            List linkedTemplates = unorderedLinkedTemplates.stream().sorted(Comparator.comparing(com.comalatech.workflow.model.Workflow::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
            for (com.comalatech.workflow.model.Workflow workflow : linkedTemplates) {
                Workflow workflowModel = (Workflow)workflow;
                List labels = page.getLabels();
                if (label != null) {
                    labels.add(label);
                }
                if (!((Workflow)workflow).isActiveForAbstractPage(page) || !workflowModel.isActiveForLabels(labels)) continue;
                workflows.add((Workflow)workflow);
            }
            if (this.workflowConfigurationManager.getConfiguration().isSpaceWorkflowsAllowed(page.getSpaceKey())) {
                List<Workflow> unorderedSpaceTemplates = this.workflowContainerManager.getCachedProductionWorkflows(page, label);
                List spaceTemplates = unorderedSpaceTemplates.stream().sorted(Comparator.comparing(Workflow::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
                workflows.addAll(spaceTemplates);
            }
            boolean isPageWorkflow = false;
            if (this.workflowConfigurationManager.getConfiguration().isPageApprovalsAllowed(page) && workflows.isEmpty() && (pageWorkflow = this.adhocWorkflowManager.getPageWorkflow(page)) != null) {
                isPageWorkflow = true;
                workflows.add(pageWorkflow);
            }
            if ((pageWorkflows = new PageWorkflows(valueStore, workflows, isPageWorkflow)).isEmpty()) {
                pageWorkflows = null;
            } else {
                if (!this.hasLicense()) {
                    return null;
                }
                this.setTasksMode(pageWorkflows);
            }
            if (log.isDebugEnabled()) {
                log.debug(page + " returning active workflows: " + pageWorkflows);
            }
            if (this.analyticsManager.canResolveAnalytics() && pageWorkflows != null && !pageWorkflows.getWorkflows().isEmpty()) {
                this.storeWorkflowsUseCase.create(pageWorkflows.getWorkflows().get(0));
            }
            return pageWorkflows;
        }
        catch (WorkflowException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new WorkflowException(e.getMessage());
        }
    }

    private AbstractPage getPageFromEvent(ConfluenceEvent event) {
        return TriggerEvents.getPage(event);
    }

    private void setTasksMode(PageWorkflows pageWorkflows) {
        for (Workflow workflow : pageWorkflows.getWorkflows()) {
            if (workflow.getTasksMode() == TasksMode.DEFAULT) continue;
            pageWorkflows.setStrictTasks(workflow.getTasksMode() == TasksMode.STRICT);
            return;
        }
        TasksMode mode = this.workflowConfigurationManager.getTasksMode(pageWorkflows.getPage().getSpaceKey(), true);
        pageWorkflows.setStrictTasks(mode == TasksMode.STRICT);
    }

    private boolean hasLicense() throws WorkflowException {
        int workflowsCount = this.workflowContainerManager.getCachedNumberOfProductionWorkflows();
        if (!this.adhocWorkflowsLicenseManager.isLicensed()) {
            PluginLicenseStatus status = this.adhocWorkflowsLicenseManager.getLicenseStatus(workflowsCount, false);
            log.warn(status.getMessageHtml());
            return false;
        }
        return true;
    }

    @Override
    public List<Approval> getAllApprovalsForSpace(String spaceKey) {
        List<Workflow> workflows = this.getAllWorkflowsForSpace(spaceKey);
        HashMap<String, Approval> allApprovals = new HashMap<String, Approval>();
        for (Workflow workflow : workflows) {
            for (Approval approval : workflow.getStatesContainer().getAllApprovals()) {
                allApprovals.put(approval.getName(), approval);
            }
        }
        List<com.comalatech.workflow.model.Workflow> linkedWorkflows = this.linkedTemplateManager.getLinkedTemplates(spaceKey);
        for (com.comalatech.workflow.model.Workflow workflow : linkedWorkflows) {
            Workflow workflowModel = (Workflow)workflow;
            for (Approval approval : workflowModel.getStatesContainer().getAllApprovals()) {
                allApprovals.put(approval.getName(), approval);
            }
        }
        ArrayList<Approval> arrayList = new ArrayList<Approval>(allApprovals.values());
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public boolean hasWorkflows(Space space) {
        return this.workflowContainerManager.hasProductionWorkflows(space) || this.workflowConfigurationManager.getConfiguration().isPageApprovalsAllowed(space.getKey()) && this.approvalsSearchService.hasStates(space.getKey());
    }

    @Override
    public Workflows getBlueprintWorkflows() {
        Workflows workflows = new Workflows();
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(WorkflowModuleDescriptor.class);
        PageContext pageContext = new PageContext();
        for (WorkflowModuleDescriptor descriptor : descriptors) {
            Workflow workflow = descriptor.getModule();
            if (workflow == null) continue;
            workflow.setRenderedDescription(this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)pageContext, workflow.getDescription()));
            workflows.add(workflow);
        }
        return workflows;
    }
}

