/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.service.provider;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetail;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.mapper.GenericEventActivityMapper;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.provider.AbstractPageActivityProvider;
import com.comalatech.confluence.documentActivity.service.provider.confluence.filter.DateRangeFilter;
import com.comalatech.confluence.documentActivity.service.provider.confluence.filter.NextActivityFilter;
import com.comalatech.confluence.documentActivity.service.provider.confluence.filter.UserFilter;
import com.comalatech.confluence.documentActivity.service.provider.confluence.filter.contract.CommentActivityFilter;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageCommentsActivityProvider
extends AbstractPageActivityProvider<Comment> {
    private static final Logger log = LoggerFactory.getLogger(PageCommentsActivityProvider.class);
    private List<CommentActivityFilter> commentActivityFilters;

    public PageCommentsActivityProvider(ContentEntityManager contentEntityManager, ActorUtils actorUtils) {
        super(contentEntityManager, actorUtils);
        this.excludingTypes = Arrays.stream(ActionType.Type.values()).filter(type -> !type.equals((Object)ActionType.Type.COMMENT)).collect(Collectors.toList());
        this.activityType = ActionType.Type.COMMENT;
        this.activitySubtypes = Collections.emptyList();
        this.commentActivityFilters = Arrays.asList(new NextActivityFilter(), new DateRangeFilter(), new UserFilter());
    }

    @Override
    protected boolean matchesFilters(Comment comment, DocumentActivityQuery query) {
        return this.commentActivityFilters.parallelStream().allMatch(filter -> filter.filter(comment, query));
    }

    @Override
    public List<Activity> get(DocumentActivityQuery query) {
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format("Getting confluence comment activities for this query filters: {0}", query));
        }
        if (!this.shouldApply(query)) {
            log.debug("Confluence comments provider skipped");
            return Collections.emptyList();
        }
        ContentEntityObject ceo = this.getContent(query);
        Comparator<Comment> sorter = Comparator.comparingLong(entry -> entry.getCreationDate().getTime());
        if (DocumentActivityQuery.SortingOrder.asc != query.getSorting()) {
            sorter = sorter.reversed();
        }
        return ((Stream)ceo.getComments().parallelStream().filter(comment -> this.matchesFilters((Comment)comment, query)).sequential()).sorted(sorter).limit(query.getLimit() + 5).map(comment -> this.buildPageCommentActivity((Comment)comment, ceo)).collect(Collectors.toList());
    }

    private Activity buildPageCommentActivity(Comment comment, ContentEntityObject ceo) {
        long moment = comment.getCreationDate().getTime();
        Actor actor = this.actorUtils.buildActor(comment.getCreator());
        ActionDetails actionDetails = new ActionDetails();
        actionDetails.addDetail(ActionDetail.Type.PAGE_COMMENT, comment.getBodyAsString());
        Action action = new Action(new ActionType(ActionType.Type.COMMENT, null), actor, actionDetails);
        String spaceKey = ceo instanceof AbstractPage ? ((AbstractPage)ceo).getSpaceKey() : null;
        return new Activity(GenericEventActivityMapper.buildTarget(ceo.getId(), ceo.getVersion(), spaceKey, null), moment, action);
    }
}

