/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.command;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.core.service.ServiceCommandValidator;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.adhoc.command.AbstractAdhocWorkflowCommand;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.opensymphony.util.TextUtils;

@ReadOnlyAccessBlocked
public class SaveStateCommand
extends AbstractAdhocWorkflowCommand {
    private String updatedStateName;
    private boolean taskable;
    private boolean finalFlag;
    private String updatedState;
    private String expiredState;
    private String completedState;
    private int dueDateCount;
    private String dueDatePeriod;

    @Override
    public void doWithWorkflow(Workflow workflow) throws WorkflowException {
        State state = !this.stateName.equals(this.updatedStateName) ? workflow.getStatesContainer().renameState(this.stateName, this.updatedStateName) : workflow.getStatesContainer().getState(this.stateName);
        state.setTaskable(this.taskable);
        if (this.finalFlag) {
            if (!state.isFinalState()) {
                state.setFinalState(this.finalFlag);
                workflow.getStatesContainer().setFinalState(state);
            }
        } else if (state.isFinalState()) {
            state.setFinalState(this.finalFlag);
            workflow.getStatesContainer().setFinalState(null);
        }
        if (TextUtils.stringSet((String)this.updatedState)) {
            state.setUpdatedStateName(this.updatedState);
        } else {
            state.setUpdatedStateName(null);
        }
        if (TextUtils.stringSet((String)this.completedState)) {
            state.setCompletedStateName(this.completedState);
        } else {
            state.setCompletedStateName(null);
        }
        if (this.dueDateCount > 0) {
            try {
                state.setDueDate(TimerUtils.periodToString(TimerUtils.parsePeriod(this.dueDateCount, this.dueDatePeriod)));
            }
            catch (MacroException e) {
                throw new WorkflowException(e);
            }
            if (TextUtils.stringSet((String)this.expiredState)) {
                state.setExpiredStateName(this.expiredState);
            }
        } else {
            state.setNoDueDate();
            state.setExpiredStateName(null);
        }
    }

    @Override
    public void validateWorkflow(ServiceCommandValidator validator, Workflow workflow) {
        if (!this.stateName.equals(this.updatedStateName)) {
            if (!State.isValidStateName(this.updatedStateName)) {
                validator.addValidationError("comalatech.awp.designer.error.state.name.invalid", new Object[]{this.updatedStateName});
            } else if (workflow.getStatesContainer().getState(this.updatedStateName) != null) {
                validator.addValidationError("comalatech.awp.designer.error.state.name.duplicate", new Object[]{this.updatedStateName});
            }
        }
        if (this.finalFlag && workflow.getStatesContainer().getFinalState() != null && !workflow.getStatesContainer().getFinalState().getName().equals(this.stateName)) {
            validator.addValidationError("comalatech.awp.designer.error.state.final.duplicate", new Object[]{workflow.getStatesContainer().getFinalState().getName()});
        }
        if (TextUtils.stringSet((String)this.updatedState) && workflow.getStatesContainer().getState(this.updatedState) == null) {
            validator.addValidationError("comalatech.awp.designer.error.state.name.invalid", new Object[]{this.updatedState});
        }
    }

    @Override
    public boolean requiresExistingState() {
        return true;
    }

    @Override
    public boolean requiresExistingTask() {
        return false;
    }

    public void setUpdatedStateName(String updatedStateName) {
        this.updatedStateName = updatedStateName;
    }

    public void setTaskable(boolean taskable) {
        this.taskable = taskable;
    }

    public void setFinalFlag(boolean finalFlag) {
        this.finalFlag = finalFlag;
    }

    public void setUpdatedState(String updatedState) {
        this.updatedState = updatedState;
    }

    public void setDueDateCount(int dueDateCount) {
        this.dueDateCount = dueDateCount;
    }

    public void setDueDatePeriod(String dueDatePeriod) {
        this.dueDatePeriod = dueDatePeriod;
    }

    public void setExpiredState(String expiredState) {
        this.expiredState = expiredState;
    }

    public void setCompletedState(String completedState) {
        this.completedState = completedState;
    }
}

