/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaLocation;
import org.everit.json.schema.loader.JsonArray;
import org.everit.json.schema.loader.JsonObject;
import org.everit.json.schema.loader.JsonPointerEvaluator;
import org.everit.json.schema.loader.JsonValue;
import org.everit.json.schema.loader.LoadingState;
import org.everit.json.schema.loader.OrgJsonUtil;
import org.everit.json.schema.loader.ReferenceKnot;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.SpecificationVersion;
import org.everit.json.schema.loader.Uri;
import org.everit.json.schema.loader.internal.ReferenceResolver;
import org.json.JSONObject;

class ReferenceLookup {
    private final LoadingState ls;
    private final SchemaClient schemaClient;

    @Deprecated
    static JSONObject extend(JSONObject additional, JSONObject original) {
        return new JSONObject(ReferenceLookup.extend(OrgJsonUtil.toMap(additional), OrgJsonUtil.toMap(original)));
    }

    static Map<String, Object> extend(Map<String, Object> additional, Map<String, Object> original) {
        if (additional.keySet().isEmpty()) {
            return original;
        }
        if (original.keySet().isEmpty()) {
            return additional;
        }
        HashMap<String, Object> rawObj = new HashMap<String, Object>();
        original.forEach(rawObj::put);
        additional.forEach(rawObj::put);
        return rawObj;
    }

    static JsonObject lookupObjById(JsonValue val, String idAttrVal) {
        block4: {
            block3: {
                String idKeyword = val.ls.specVersion().idKeyword();
                if (!(val instanceof JsonObject)) break block3;
                JsonObject obj = (JsonObject)val;
                if (obj.containsKey(idKeyword) && obj.require(idKeyword).typeOfValue() == String.class && obj.require(idKeyword).requireString().equals(idAttrVal)) {
                    return obj;
                }
                for (String key : obj.keySet()) {
                    JsonObject maybeFound = ReferenceLookup.lookupObjById(obj.require(key), idAttrVal);
                    if (maybeFound == null) continue;
                    return maybeFound;
                }
                break block4;
            }
            if (!(val instanceof JsonArray)) break block4;
            JsonArray arr = (JsonArray)val;
            for (int i = 0; i < arr.length(); ++i) {
                JsonObject maybeFound = ReferenceLookup.lookupObjById(arr.at(i), idAttrVal);
                if (maybeFound == null) continue;
                return maybeFound;
            }
        }
        return null;
    }

    static URI withoutFragment(String fullUri) {
        int hashmarkIdx = fullUri.indexOf(35);
        String rval = hashmarkIdx == -1 ? fullUri : fullUri.substring(0, hashmarkIdx);
        try {
            return new URI(rval);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public ReferenceLookup(LoadingState ls) {
        this.ls = Objects.requireNonNull(ls, "ls cannot be null");
        this.schemaClient = ls.config.schemaClient;
    }

    private Map<String, Object> doExtend(Map<String, Object> additional, Map<String, Object> original) {
        if (this.ls.specVersion() == SpecificationVersion.DRAFT_4) {
            return ReferenceLookup.extend(additional, original);
        }
        return original;
    }

    Map<String, Object> withoutRef(JsonObject original) {
        HashMap<String, Object> rawObj = new HashMap<String, Object>();
        original.keySet().stream().filter(name -> !"$ref".equals(name)).forEach(name -> rawObj.put((String)name, original.get((String)name)));
        return rawObj;
    }

    private Schema.Builder<?> performQueryEvaluation(String mapKey, JsonPointerEvaluator pointerEvaluator) {
        String absolutePointer = ReferenceResolver.resolve(this.ls.id, mapKey).toString();
        if (this.ls.pointerSchemas.containsKey(absolutePointer)) {
            return this.ls.pointerSchemas.get(absolutePointer).initReference(absolutePointer);
        }
        JsonValue referencedRawSchema = pointerEvaluator.query().getQueryResult();
        return this.createReferenceSchema(mapKey, absolutePointer, referencedRawSchema);
    }

    Schema.Builder<?> lookup(String relPointerString, JsonObject ctx) {
        String absPointerString = ReferenceResolver.resolve(this.ls.id, relPointerString).toString();
        if (this.ls.pointerSchemas.containsKey(absPointerString)) {
            return this.ls.pointerSchemas.get(absPointerString).initReference(absPointerString);
        }
        JsonObject rawInternalReferenced = ReferenceLookup.lookupObjById(this.ls.rootSchemaJson, absPointerString);
        if (rawInternalReferenced != null) {
            return this.createReferenceSchema(relPointerString, absPointerString, rawInternalReferenced);
        }
        if (this.isSameDocumentRef(relPointerString)) {
            return this.performQueryEvaluation(relPointerString, JsonPointerEvaluator.forDocument(this.ls.rootSchemaJson(), relPointerString));
        }
        JsonPointerEvaluator pointer = this.createPointerEvaluator(absPointerString);
        ReferenceKnot knot = new ReferenceKnot();
        ReferenceSchema.Builder refBuilder = knot.initReference(relPointerString);
        this.ls.pointerSchemas.put(absPointerString, knot);
        JsonPointerEvaluator.QueryResult result = pointer.query();
        URI resolutionScope = !this.isSameDocumentRef(absPointerString) ? ReferenceLookup.withoutFragment(absPointerString) : this.ls.id;
        JsonObject containingDocument = result.getContainingDocument();
        SchemaLocation resultLocation = result.getQueryResult().ls.pointerToCurrentObj;
        SchemaLoader childLoader = this.ls.initNewDocumentLoader().pointerToCurrentObj(resultLocation).resolutionScope(resolutionScope).schemaJson(result.getQueryResult()).rootSchemaJson(containingDocument).build();
        Object referredSchema = childLoader.load().build();
        refBuilder.schemaLocation(resultLocation);
        knot.resolveWith((Schema)referredSchema);
        return refBuilder;
    }

    private Schema.Builder<?> createReferenceSchema(String relPointerString, String absPointerString, JsonValue rawReferenced) {
        ReferenceKnot knot = new ReferenceKnot();
        ReferenceSchema.Builder refBuilder = knot.initReference(relPointerString);
        this.ls.pointerSchemas.put(absPointerString, knot);
        Object referredSchema = new SchemaLoader(rawReferenced.ls).load().build();
        knot.resolveWith((Schema)referredSchema);
        return refBuilder;
    }

    private JsonObject initJsonObjectById(URI id) {
        JsonObject o = JsonValue.of(this.ls.config.schemasByURI.get(id)).requireObject();
        new LoadingState(this.ls.config, this.ls.pointerSchemas, o, o, id, SchemaLocation.parseURI(id.toString()));
        return o;
    }

    private JsonPointerEvaluator createPointerEvaluator(String absPointerString) {
        if (this.isSameDocumentRef(absPointerString)) {
            return JsonPointerEvaluator.forDocument(this.ls.rootSchemaJson(), absPointerString);
        }
        try {
            Uri uri = Uri.parse(absPointerString);
            if (this.ls.config.schemasByURI.containsKey(uri.asJavaURI())) {
                JsonObject o = this.initJsonObjectById(uri.asJavaURI());
                return JsonPointerEvaluator.forDocument(o, "#");
            }
            if (this.ls.config.schemasByURI.containsKey(uri.toBeQueried)) {
                JsonObject o = this.initJsonObjectById(uri.toBeQueried);
                return JsonPointerEvaluator.forDocument(o, uri.fragment);
            }
        }
        catch (URISyntaxException e) {
            throw this.ls.createSchemaException(e);
        }
        return JsonPointerEvaluator.forURL(this.schemaClient, absPointerString, this.ls);
    }

    private boolean isSameDocumentRef(String ref) {
        return ref.startsWith("#");
    }
}

