/*
 * Decompiled with CFR 0.152.
 */
package net.customware.confluence.reporting.query;

import java.util.ArrayList;
import java.util.List;
import net.customware.confluence.reporting.Filterable;
import net.customware.confluence.reporting.query.CachingQuery;
import net.customware.confluence.reporting.query.IteratorResults;
import net.customware.confluence.reporting.query.QueryException;
import net.customware.confluence.reporting.query.Results;
import org.randombits.confluence.filtering.criteria.Criteria;
import org.randombits.confluence.filtering.criteria.Criterion;
import org.randombits.confluence.filtering.criteria.GroupCriteria;
import org.randombits.confluence.support.MacroInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQuery<V>
implements CachingQuery<V>,
Filterable {
    public static final String MATCH_ALL_PARAM = "matchAll";
    private GroupCriteria criteria;
    private ArrayList<V> items;

    public AbstractQuery(MacroInfo info) throws QueryException {
        this.init(info);
    }

    protected void init(MacroInfo info) throws QueryException {
        boolean matchAllCriteria = info.getMacroParams().getBoolean(MATCH_ALL_PARAM, true);
        this.criteria = new GroupCriteria(matchAllCriteria, new Criterion[0]);
    }

    @Override
    public boolean addCriterion(Criterion criterion) {
        this.criteria.addCriterion(criterion);
        this.clearCache();
        return true;
    }

    @Override
    public void clearCache() {
        this.items = null;
    }

    @Override
    public Criteria getCriteria() {
        return this.criteria;
    }

    @Override
    public Results<V> execute() throws QueryException {
        if (this.items == null) {
            this.items = new ArrayList();
            this.findItems(this.items, this.criteria);
        }
        return new IteratorResults<V>(this.items);
    }

    protected abstract void findItems(List<V> var1, Criteria var2) throws QueryException;
}

