/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.model.mappers.documentreport;

import com.comalatech.confluence.workflow.documentReport.ApprovalsDataEnum;
import com.comalatech.confluence.workflow.restv2.model.documentreport.WorkflowsReportData;
import com.comalatech.confluence.workflow.restv2.model.mappers.documentreport.DocumentReportJsonPropertyMapper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class ApprovalsMapper
implements DocumentReportJsonPropertyMapper {
    @Override
    public WorkflowsReportData map(String key, String json, WorkflowsReportData result) {
        Optional<ApprovalsDataEnum> approvalsDataEnum = ApprovalsDataEnum.fromString(key);
        if (result == null) {
            result = new WorkflowsReportData();
        }
        if (approvalsDataEnum.isPresent()) {
            List approvalsNameList = approvalsDataEnum.map(dataEnum -> dataEnum.getApprovalsData(json)).orElse(Collections.emptyList());
            switch (approvalsDataEnum.get()) {
                case COMALA_WORKFLOWS_PENDING_APPROVALS: {
                    result.pendingApprovals = approvalsNameList;
                    break;
                }
                case COMALA_WORKFLOWS_APPROVED_APPROVALS: {
                    result.approvedApprovals = approvalsNameList;
                    break;
                }
                case COMALA_WORKFLOWS_REJECTED_APPROVALS: {
                    result.rejectedApprovals = approvalsNameList;
                }
            }
        }
        return result;
    }
}

