/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.ipc;

import bucket.core.actions.PaginationSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.macros.actions.IpcMacro;
import com.comalatech.confluence.workflow.model.Approval;
import com.comalatech.confluence.workflow.model.DecoratedApprovalCheck;
import com.comalatech.confluence.workflowreports.WorkflowReportManager;
import com.comalatech.confluence.workflowreports.model.WorkflowReport;
import com.comalatech.confluence.workflowreports.model.WorkflowReportEntry;
import com.comalatech.confluence.workflowreports.model.WorkflowReportOptions;
import com.comalatech.confluence.workflowreports.model.WorkflowReportSortEnum;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;

public class ApprovalsReportMacro
extends IpcMacro {
    private static final int MAX_ENTRIES = 500;
    private static final String PARAM_SPACEKEY = "spacekey";
    private static final String PARAM_APPROVALNAME = "approval";
    private static final String PARAM_FILTER = "filter";
    private static final String PARAM_START = "start";
    private static final String PARAM_COUNT = "count";
    private static final String PARAM_SORT = "sort";
    private static final String PARAM_REVERSE = "reverse";
    private static final String SORT_APPROVED_DATE = "date";
    private static final String SORT_TITLE = "title";
    private static final String SORT_UPDATED = "updated";
    private static final String SORT_APPROVER = "approver";
    public static final String IPC_APPROVAL_NAME = "approvalname";
    public static final String IPC_APPROVALS_NAMES = "approvalsnames";
    public static final String IPC_APPROVAL_CHECKS = "approvalschecks";
    public static final String IPC_APPROVALS_COUNT = "approvalsCount";
    private UserAccessor userAccessor;
    private WorkflowReportManager workflowReportManager;
    private WorkflowConfigurationManager workflowConfigurationManager;

    @Override
    protected String getName() {
        return "approvals-report";
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        int reverseFactor;
        this.checkRunMode(renderContext);
        String spaceKey = (String)parameters.get(PARAM_SPACEKEY);
        String approvalName = (String)parameters.get(PARAM_APPROVALNAME);
        String filter = (String)parameters.get(PARAM_FILTER);
        int start = NumberUtils.toInt((String)((String)parameters.get(PARAM_START)));
        int count = NumberUtils.toInt((String)((String)parameters.get(PARAM_COUNT)));
        int n = reverseFactor = Boolean.TRUE.toString().equalsIgnoreCase((String)parameters.get(PARAM_REVERSE)) ? -1 : 1;
        if (!TextUtils.stringSet((String)spaceKey)) {
            throw new MacroException("spaceKey not set");
        }
        String sort = (String)parameters.get(PARAM_SORT);
        int sortType = SORT_TITLE.equalsIgnoreCase(sort) ? 2 : (SORT_UPDATED.equalsIgnoreCase(sort) ? 3 : (SORT_APPROVER.equalsIgnoreCase(sort) ? 4 : 1));
        WorkflowReportOptions options = new WorkflowReportOptions(spaceKey, this.getPage(renderContext).getSpaceKey(), WorkflowReportSortEnum.getDefault(), 500);
        WorkflowReport report = this.workflowReportManager.createReport(options, new PaginationSupport(500));
        List approvals = report.getApprovals();
        List<WorkflowReportEntry> results = report.getEntries();
        Collections.sort(results, new PageApprovalsComparator(sortType, reverseFactor));
        if (count == 0) {
            count = results.size();
        }
        int elements = start + count > results.size() ? results.size() : start + count;
        ArrayList<Map> response = new ArrayList<Map>(elements);
        for (int i = start; i < elements; ++i) {
            Map attributes = this.makeEntryAttributes(results.get(i));
            response.add(attributes);
        }
        ArrayList<String> approvalNames = new ArrayList<String>(approvals.size());
        for (Approval approval : approvals) {
            approvalNames.add(approval.getName());
        }
        renderContext.getParams().put(IPC_APPROVAL_CHECKS, response);
        renderContext.getParams().put(IPC_APPROVAL_NAME, approvalName);
        renderContext.getParams().put(IPC_APPROVALS_NAMES, approvalNames);
        renderContext.getParams().put(IPC_APPROVALS_COUNT, new Integer(results.size()));
        return "";
    }

    private Map makeEntryAttributes(WorkflowReportEntry entry) {
        HashMap<String, String> map = new HashMap<String, String>();
        AbstractPage page = entry.getPage();
        map.put("pageId", page.getIdAsString());
        DecoratedApprovalCheck approvalCheck = entry.getApproval();
        if (approvalCheck != null) {
            map.put("approvalComment", ((DecoratedApprovalCheck.DecoratedApprover)approvalCheck.getRecentApprovers().get(0)).getComment());
            map.put("approvalDate", ((DecoratedApprovalCheck.DecoratedApprover)approvalCheck.getRecentApprovers().get(0)).getDate());
            map.put("approvalUserLink", ((DecoratedApprovalCheck.DecoratedApprover)approvalCheck.getRecentApprovers().get(0)).getUserLink());
            map.put("approvalApprovedPageLink", (String)approvalCheck.getApprovedPageLink());
            map.put("approvalUpToDate", Boolean.toString(approvalCheck.isUpToDate()));
        }
        return map;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setWorkflowReportManager(WorkflowReportManager workflowReportManager) {
        this.workflowReportManager = workflowReportManager;
    }

    public void setWorkflowConfigurationManager(WorkflowConfigurationManager workflowConfigurationManager) {
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    private class PageApprovalsComparator
    implements Comparator {
        public static final int SORT_BY_DATE = 1;
        public static final int SORT_BY_TITLE = 2;
        public static final int SORT_BY_UPDATED = 3;
        public static final int SORT_BY_APPROVER = 4;
        private int sortType;
        private Map userNames;
        private int reverseFactor;

        public PageApprovalsComparator(int sortType, int reverseFactor) {
            this.sortType = sortType;
            this.userNames = new HashMap();
            this.reverseFactor = reverseFactor;
        }

        public int compare(Object o, Object o1) {
            WorkflowReportEntry a = (WorkflowReportEntry)o;
            WorkflowReportEntry a1 = (WorkflowReportEntry)o1;
            switch (this.sortType) {
                case 2: {
                    return a.getPage().getTitle().toLowerCase().compareTo(a1.getPage().getTitle().toLowerCase()) * this.reverseFactor;
                }
                case 3: {
                    long d = a.getPage().getLastModificationDate().getTime();
                    long d1 = a1.getPage().getLastModificationDate().getTime();
                    if (d1 < d) {
                        return -1 * this.reverseFactor;
                    }
                    if (d1 > d) {
                        return 1 * this.reverseFactor;
                    }
                    return 0;
                }
                case 4: {
                    DecoratedApprovalCheck ac = a.getApproval();
                    DecoratedApprovalCheck ac1 = a1.getApproval();
                    String n = ac != null ? this.getUserName(((DecoratedApprovalCheck.DecoratedApprover)ac.getRecentApprovers().get(0)).getUserName()) : this.getUserName(a.getPage().getLastModifierName());
                    String n1 = ac1 != null ? this.getUserName(((DecoratedApprovalCheck.DecoratedApprover)ac1.getRecentApprovers().get(0)).getUserName()) : this.getUserName(a1.getPage().getLastModifierName());
                    return n.compareTo(n1) * this.reverseFactor;
                }
            }
            DecoratedApprovalCheck ac = a.getApproval();
            DecoratedApprovalCheck ac1 = a1.getApproval();
            long d = ac != null ? ac.getTime().getTime() : a.getPage().getLastModificationDate().getTime();
            long d1 = ac1 != null ? ac1.getTime().getTime() : a1.getPage().getLastModificationDate().getTime();
            if (d1 < d) {
                return -1 * this.reverseFactor;
            }
            if (d1 > d) {
                return 1 * this.reverseFactor;
            }
            return 0;
        }

        private String getUserName(String userId) {
            String name = (String)this.userNames.get(userId);
            if (name != null) {
                return name;
            }
            ConfluenceUser user = ApprovalsReportMacro.this.userAccessor.getUserByName(userId);
            name = user == null ? "" : user.getFullName();
            this.userNames.put(userId, name);
            return name;
        }
    }
}

