/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.actions;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.credentials.Credentials;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.workflow.ApprovalManager;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.macros.actions.IpcMacro;
import com.comalatech.confluence.workflow.rpc.RemoteApprover;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Map;

public class ApprovePageMacro
extends IpcMacro {
    public static final String PARAM_PAGEID = "pageid";
    public static final String PARAM_PAGENAME = "pagename";
    public static final String PARAM_SPACEKEY = "spacekey";
    public static final String PARAM_APPROVALNAME = "approvalname";
    public static final String PARAM_COMMENT = "comment";
    public static final String PARAM_APPROVED = "approved";
    public static final String PARAM_NEXTAPPROVERS = "nextapprovers";
    public static final String PARAM_CHILD_APPROVAL_STATE = "state";
    public static final String PARAM_REMOTE_CREDENTIALS = "credentials";
    protected ApprovalManager approvalManager;
    private PageManager pageManager;
    protected String childApprovedState;

    protected String getChildApprovedState() {
        return this.childApprovedState;
    }

    @Override
    protected String getName() {
        return "approve-page";
    }

    protected void approve(String approvalName, String comment, AbstractPage page, boolean approved) throws WorkflowException {
        this.approvalManager.approvePage(page, approvalName, approved, comment, AuthenticatedUserThreadLocal.get(), true, false, false, false);
    }

    protected Map remoteApprove(String approvalName, String comment, AbstractPage page, boolean approved, String nextApprovers, Credentials remoteCredentials) throws WorkflowException {
        RemoteApprover remoteApprover = new RemoteApprover(remoteCredentials, page);
        return remoteApprover.approve(approvalName, comment, nextApprovers, approved);
    }

    protected boolean getApproveFlag(Map parameters) {
        String flag = (String)parameters.get(PARAM_APPROVED);
        return flag == null || Boolean.TRUE.toString().equalsIgnoreCase(flag);
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        this.checkRunMode(renderContext);
        String pageId = (String)parameters.get(PARAM_PAGEID);
        String pageName = (String)parameters.get(PARAM_PAGENAME);
        String spaceKey = (String)parameters.get(PARAM_SPACEKEY);
        String approvalName = (String)parameters.get(PARAM_APPROVALNAME);
        String comment = (String)parameters.get(PARAM_COMMENT);
        String credentialsKey = (String)parameters.get(PARAM_REMOTE_CREDENTIALS);
        this.childApprovedState = (String)parameters.get(PARAM_CHILD_APPROVAL_STATE);
        if (this.childApprovedState != null && renderContext.getParam((Object)"workflow") != null && !((ArrayList)renderContext.getParam((Object)"workflow")).isEmpty() && !this.isValidChildApprovalState(renderContext, this.childApprovedState)) {
            throw new MacroException("Invalid state name '" + this.childApprovedState + "' for approve-children");
        }
        if (!TextUtils.stringSet((String)approvalName)) {
            if (this.inWorkflowAction(renderContext) || this.inWorkflowMacro(renderContext)) {
                approvalName = (String)parameters.get("0");
            }
            if (!TextUtils.stringSet((String)approvalName)) {
                throw new MacroException("approvalName not provided");
            }
        }
        AbstractPage page = (AbstractPage)((PageContext)renderContext).getEntity();
        if (!this.inExecuteMode(renderContext)) {
            if (credentialsKey != null && this.workflowPropertiesManager.getWorkflowProperites(renderContext, credentialsKey) == null) {
                throw new MacroException("Remote confluence crendentials must be defined as workflow properties '" + credentialsKey + "'");
            }
            return "";
        }
        if (!this.inWorkflowAction(renderContext)) {
            if (TextUtils.stringSet((String)pageId)) {
                long pid;
                try {
                    pid = Long.parseLong(pageId.trim());
                }
                catch (Exception e) {
                    throw new MacroException("Invalid pageId " + pageId);
                }
                page = this.pageManager.getPage(pid);
                if (page == null) {
                    throw new MacroException("pageId " + pageId + " not found");
                }
            } else {
                if (!TextUtils.stringSet((String)spaceKey)) {
                    throw new MacroException("spaceKey not provided");
                }
                if (!TextUtils.stringSet((String)pageName)) {
                    throw new MacroException("pageName not provided");
                }
                page = this.pageManager.getPage(spaceKey.trim(), pageName.trim());
                if (page == null) {
                    throw new MacroException("page " + spaceKey + ":" + pageName + " not found");
                }
            }
        }
        boolean approved = this.getApproveFlag(parameters);
        String nextApprovers = (String)parameters.get(PARAM_NEXTAPPROVERS);
        try {
            ValueStore valueStore = this.getValueStore(renderContext);
            if (comment != null) {
                comment = valueStore.replaceReferences(comment);
            }
            Credentials remoteCredentials = null;
            if (credentialsKey != null) {
                remoteCredentials = this.getAndValidateCredentials(valueStore, credentialsKey, parameters);
            }
            if (remoteCredentials == null) {
                this.approve(approvalName, comment, page, approved);
            } else {
                Map map = this.remoteApprove(approvalName, comment, page, approved, nextApprovers, remoteCredentials);
                valueStore.putProperties(map);
            }
        }
        catch (WorkflowException e) {
            this.logMessage(renderContext, e);
        }
        return "";
    }

    private boolean inWorkflowMacro(RenderContext renderContext) {
        return renderContext.getParam((Object)"workflow") != null;
    }

    private Credentials getAndValidateCredentials(ValueStore valueStore, String credentialsKey, Map parameters) throws WorkflowException {
        Map credentialsMap = valueStore.getPageWorkflows().getProperties(credentialsKey);
        if (credentialsMap == null) {
            throw new WorkflowException("Remote confluence crendentials must be defined as workflow properties '" + credentialsKey + "'");
        }
        Credentials credentials = new Credentials(credentialsMap);
        credentials.override(parameters);
        try {
            credentials.validate();
        }
        catch (Exception e) {
            throw new WorkflowException(e.getMessage());
        }
        return credentials;
    }

    private boolean isValidChildApprovalState(RenderContext renderContext, String childApprovedState) {
        return ((ArrayList)renderContext.getParam((Object)"workflow")).stream().anyMatch(elem -> elem instanceof State && childApprovedState.equals(((State)elem).getName()));
    }

    public void setApprovalManager(ApprovalManager approvalManager) {
        this.approvalManager = approvalManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }
}

