/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.analytics;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.comalatech.confluence.analytics.StatField;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.analytics.CommonAnalyticsManager;
import com.comalatech.confluence.workflow.analytics.ESignatureStatsGatherer;
import com.comalatech.confluence.workflow.analytics.ReadAckInformationGatherer;
import com.comalatech.confluence.workflow.analytics.UpgradeStatsGatherer;
import com.comalatech.confluence.workflow.analytics.catalog.StatsCatalog;
import com.comalatech.confluence.workflow.service.ApprovalsSearchService;
import com.comalatech.confluence.workflow.stats.WorkflowStatisticsManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluationAnalyticsManager
extends CommonAnalyticsManager {
    private static final Logger log = LoggerFactory.getLogger(EvaluationAnalyticsManager.class);

    public EvaluationAnalyticsManager(BandanaManager bandanaManager, ConfluenceSidManager confluenceSidManager, SystemInformationService systemInformationService, PluginAccessor pluginAccessor, PluginLicenseManager pluginLicenseManager, SearchManager searchManager, WorkflowStatisticsManager workflowStatisticsManager, ReadAckInformationGatherer readAckInformationGatherer, ApprovalsSearchService approvalsSearchService, WorkflowsFeatureManager workflowsFeatureManager, ESignatureStatsGatherer eSignatureStatsGatherer, SpaceManager spaceManager, UpgradeStatsGatherer upgradeStatsGatherer) {
        super(bandanaManager, confluenceSidManager, systemInformationService, pluginAccessor, pluginLicenseManager, searchManager, approvalsSearchService, spaceManager, workflowsFeatureManager, readAckInformationGatherer, eSignatureStatsGatherer, workflowStatisticsManager, upgradeStatsGatherer);
    }

    @Override
    public StatField[] getDefaultStatFields() {
        return new StatField[]{new StatField("timestamp", () -> new Date().getTime()), new StatField("app", () -> this.getFriendApps().entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(this.pluginLicenseManager.getPluginKey())).findFirst().map(Map.Entry::getValue).orElse("---")), new StatField("version", () -> {
            try {
                Manifest manifest = new Manifest(this.getClass().getClassLoader().getResourceAsStream("META-INF/MANIFEST.MF"));
                return manifest.getMainAttributes().getValue("Bundle-Version");
            }
            catch (IOException e) {
                return "---";
            }
        }), new StatField(StatsCatalog.STAT_APP_SEN, this::getAppSupportEntitlementNumber), new StatField(StatsCatalog.STAT_CONFLUENCE_SEN, this::getConfluenceSupportEntitlementNumber)};
    }

    @Override
    public boolean canResolveAnalytics() {
        return true;
    }

    @Override
    public void resolveAnalytics() {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        Arrays.stream(this.getStatFields()).forEach(f -> valuesMap.put(f.getName(), (String)f.getProcessor().execute()));
        Arrays.asList(StatsCatalog.STAT_APP_SEN, StatsCatalog.STAT_CONFLUENCE_SEN, "timestamp").forEach(field -> {
            if (!valuesMap.containsKey(field)) {
                throw new RuntimeException("No <" + field + "> field in provided statFields: it's mandatory");
            }
        });
        String token = "{ \"appSen\": \"" + valuesMap.get(StatsCatalog.STAT_APP_SEN) + "\", \"hostSen\": \"" + valuesMap.get(StatsCatalog.STAT_CONFLUENCE_SEN) + "\", \"timestamp\": \"" + valuesMap.get("timestamp") + "\" }";
        String signature = this.encrypt(token);
        valuesMap.put("comalatechToken", signature);
        this.bandanaManager.setValue((BandanaContext)this.getBandanaContext(), this.BANDANA_STATS_KEY, valuesMap);
        if (log.isDebugEnabled()) {
            log.debug("Recalculated stats: " + valuesMap);
        }
    }

    @Override
    public boolean showDisableAnalyticsToggleButton() {
        return false;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public String getAppSupportEntitlementNumber() {
        String appSEN = "---";
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            appSEN = (String)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getSupportEntitlementNumber().orElse(Option.option((Object)"---")).get();
        }
        return appSEN;
    }

    public String getConfluenceSupportEntitlementNumber() {
        String hostSEN = "---";
        if (this.systemInformationService.getConfluenceInfo() != null) {
            hostSEN = this.systemInformationService.getConfluenceInfo().getSupportEntitlementNumber() == null ? "---" : this.systemInformationService.getConfluenceInfo().getSupportEntitlementNumber();
        }
        return hostSEN;
    }
}

