/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.activeobjects.accessor;

import com.comalatech.confluence.util.ActiveObjectsAccessor;
import com.comalatech.confluence.workflow.activeobjects.accessor.QueuedJobEntityAccessor;
import com.comalatech.confluence.workflow.activeobjects.entity.QueuedJobEntity;
import com.comalatech.confluence.workflow.tasks.model.QueuedJobModel;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuedJobEntityAccessorImpl
extends ActiveObjectsAccessor
implements QueuedJobEntityAccessor {
    private static final Logger log = LoggerFactory.getLogger(QueuedJobEntityAccessorImpl.class);

    @Override
    public QueuedJobEntity add(QueuedJobEntityAccessor.JobType jobType, QueuedJobModel jobData) {
        QueuedJobEntity queuedJobEntity = (QueuedJobEntity)this.getAo().create(QueuedJobEntity.class, new DBParam[]{new DBParam("JOB_TYPE", (Object)jobType.toString()), new DBParam("JOB_DATA", (Object)new JSONObject(jobData).toString())});
        queuedJobEntity.save();
        if (log.isDebugEnabled()) {
            log.debug("Queued Job has been stored: \njobType: " + (Object)((Object)jobType) + "jobData: " + new JSONObject(jobData));
        }
        return queuedJobEntity;
    }

    @Override
    public List<QueuedJobEntity> findAll(String[] jobTypes, int limit) {
        String placeholderCommaList = Arrays.asList(jobTypes).stream().map(jobType -> "?").collect(Collectors.joining(","));
        ArrayList list = Lists.newArrayList((Object[])((QueuedJobEntity[])this.getAo().find(QueuedJobEntity.class, Query.select().where("JOB_TYPE IN (" + placeholderCommaList + ")", (Object[])jobTypes).order("ID ASC").limit(limit))));
        if (log.isDebugEnabled()) {
            log.debug("Number of queued jobs entities retrieved: " + list.size());
        }
        return list;
    }

    @Override
    public void delete(QueuedJobEntity queuedJobEntity) {
        if (queuedJobEntity != null) {
            this.getAo().delete(new RawEntity[]{queuedJobEntity});
            if (log.isDebugEnabled()) {
                log.debug("Queued Job entity with id \"" + queuedJobEntity.getID() + "\" deleted.");
            }
        }
    }
}

