/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.metadata.atlassian;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.plugins.pageproperties.api.model.PagePropertiesMacroInstance;
import com.atlassian.confluence.plugins.pageproperties.api.model.PagePropertiesMacroReport;
import com.atlassian.confluence.plugins.pageproperties.api.model.PageProperty;
import com.atlassian.confluence.plugins.pageproperties.api.service.PagePropertiesService;
import com.atlassian.renderer.RenderContext;
import com.comalatech.confluence.metadata.MetadataAccessor;
import com.comalatech.confluence.metadata.atlassian.PagePropertiesRenderingContext;
import com.opensymphony.util.TextUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DOMReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.tidy.Tidy;

public class AtlassianMetadataAccessor
implements MetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(AtlassianMetadataAccessor.class);
    public static final String CHARSET_UTF8 = "UTF-8";
    private final PagePropertiesService pagePropertiesService;
    private final Renderer renderer;

    public AtlassianMetadataAccessor(PagePropertiesService pagePropertiesService, Renderer renderer) {
        this.pagePropertiesService = pagePropertiesService;
        this.renderer = renderer;
    }

    @Override
    public String getValue(ContentEntityObject ceo, String value, int loopIterations) {
        if (loopIterations < PagePropertiesRenderingContext.MAX_NUM_ITERATIONS) {
            if ((value = this.getValueFromPageProperties(ceo, value, loopIterations)) != null) {
                return value;
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Skipping metadata: retrieval :" + value + ", the max number of iterations " + PagePropertiesRenderingContext.MAX_NUM_ITERATIONS + " was reached or the page property name matched the name of the property being retrieved");
        }
        return "";
    }

    private String getValueFromPageProperties(ContentEntityObject ceo, String value, int loopIterations) {
        String output = null;
        try {
            AbstractPage page;
            PagePropertiesRenderingContext renderContext;
            DefaultConversionContext pageConversionContext;
            String storageFormat;
            HashMap allPropertiesMap = new HashMap();
            PagePropertiesMacroReport report = this.pagePropertiesService.getReportFromContent(ceo);
            for (PagePropertiesMacroInstance instance : report.getAllMacroInstances()) {
                allPropertiesMap.putAll(instance.getPagePropertyReportRow());
            }
            PageProperty result = (PageProperty)allPropertiesMap.get(value);
            if (result != null && this.isHtml(output = this.renderer.render(storageFormat = result.getDetailStorageFormat().trim(), (ConversionContext)(pageConversionContext = new DefaultConversionContext((RenderContext)(renderContext = new PagePropertiesRenderingContext((ContentEntityObject)(page = (AbstractPage)ceo), value, loopIterations))))))) {
                output = this.getInnerTextFromHtml(output);
            }
        }
        catch (Exception e) {
            log.error("error parsing " + ceo, (Throwable)e);
        }
        return output;
    }

    private boolean isHtml(String string) {
        String HTML_PATTERN = "<(\"[^\"]*\"|'[^']*'|[^'\">])*>";
        Pattern pattern = Pattern.compile(HTML_PATTERN);
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    private String getInnerTextFromHtml(String htmlString) {
        htmlString = "<div>" + htmlString + "</div>";
        Document document = this.getStringHtmlDocument(htmlString);
        Element rootElement = (Element)document.selectSingleNode("//div");
        String users = this.makeUsers(rootElement);
        if (users != null) {
            return users;
        }
        try {
            return this.getInnerHtml(rootElement);
        }
        catch (IOException e) {
            return null;
        }
    }

    private String makeUsers(Element element) {
        if (element == null) {
            return null;
        }
        List users = element.selectNodes(".//a[@data-username]");
        if (users == null || users.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Node user : users) {
            Element u = (Element)user;
            String userName = u.attributeValue("data-username");
            if (!TextUtils.stringSet((String)userName)) continue;
            if (!first) {
                sb.append(",");
            }
            sb.append(userName);
            first = false;
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    private String getInnerHtml(Element element) throws IOException {
        return this.getInnerHtmlWithoutScriptTags(element, true);
    }

    private String getInnerHtmlWithoutScriptTags(Element element, boolean stripScriptTags) throws IOException {
        if (element == null) {
            return "";
        }
        if (element.isTextOnly()) {
            return StringEscapeUtils.escapeHtml4((String)element.getText());
        }
        StringWriter stringWriter = new StringWriter();
        Iterator it = element.nodeIterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (stripScriptTags) {
                ((Writer)stringWriter).write(node.getStringValue());
                continue;
            }
            node.write((Writer)stringWriter);
        }
        return ((Object)stringWriter).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getStringHtmlDocument(String stringHtml) {
        byte[] errorStreamContents;
        Document document;
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        Tidy tidy = new Tidy();
        tidy.setQuiet(true);
        tidy.setErrout(new PrintWriter(errorStream));
        tidy.setInputEncoding(CHARSET_UTF8);
        try {
            document = new DOMReader().read(tidy.parseDOM(new ByteArrayInputStream(stringHtml.getBytes(CHARSET_UTF8)), null));
            errorStreamContents = errorStream.toByteArray();
        }
        catch (UnsupportedEncodingException utf8NotSupported) {
            byte[] errorStreamContents2;
            Document document2;
            try {
                log.warn(String.format("Character set %s not supported.", CHARSET_UTF8), (Throwable)utf8NotSupported);
                document2 = new DOMReader().read(tidy.parseDOM(new ByteArrayInputStream(stringHtml.getBytes()), null));
                errorStreamContents2 = errorStream.toByteArray();
            }
            catch (Throwable throwable) {
                byte[] errorStreamContents3 = errorStream.toByteArray();
                if (errorStreamContents3.length > 0) {
                    log.warn(String.format("There were some warnings parsing the specified HTML fragment\n%s", new String(errorStreamContents3)));
                }
                throw throwable;
            }
            if (errorStreamContents2.length > 0) {
                log.warn(String.format("There were some warnings parsing the specified HTML fragment\n%s", new String(errorStreamContents2)));
            }
            return document2;
        }
        if (errorStreamContents.length > 0) {
            log.warn(String.format("There were some warnings parsing the specified HTML fragment\n%s", new String(errorStreamContents)));
        }
        return document;
    }
}

