/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.task;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetail;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.mapper.EventActivityMapper;
import com.comalatech.confluence.documentActivity.mapper.GenericEventActivityMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.event.BlogPostTaskDueDateDeletedEvent;
import com.comalatech.confluence.states.event.PageTaskDueDateDeletedEvent;
import com.comalatech.confluence.states.model.DueDateRecord;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.workflow.WorkflowUserException;

public class TaskDueDateDeletionMapper
extends GenericEventActivityMapper
implements EventActivityMapper {
    public TaskDueDateDeletionMapper(ActorUtils actorUtils) {
        super(actorUtils);
    }

    @Override
    public Activity map(ConfluenceEvent event) throws WorkflowUserException {
        if (event instanceof PageTaskDueDateDeletedEvent) {
            PageTaskDueDateDeletedEvent pageTaskDueDateDeletedEvent = (PageTaskDueDateDeletedEvent)event;
            return this.buildActivity((AbstractPage)pageTaskDueDateDeletedEvent.getPage(), (PageState)pageTaskDueDateDeletedEvent.getState(), (PageTask)pageTaskDueDateDeletedEvent.getTask());
        }
        if (event instanceof BlogPostTaskDueDateDeletedEvent) {
            BlogPostTaskDueDateDeletedEvent blogPostTaskDueDateDeletedEvent = (BlogPostTaskDueDateDeletedEvent)event;
            return this.buildActivity((AbstractPage)blogPostTaskDueDateDeletedEvent.getBlogPost(), (PageState)blogPostTaskDueDateDeletedEvent.getState(), (PageTask)blogPostTaskDueDateDeletedEvent.getTask());
        }
        return null;
    }

    protected Activity buildActivity(AbstractPage abstractPage, PageState state, PageTask pageTask) throws WorkflowUserException {
        return this.buildActivity(abstractPage, state, pageTask, pageTask.getCurrentDueDate());
    }

    protected Activity buildActivity(AbstractPage abstractPage, PageState state, PageTask pageTask, DueDateRecord dueDateRecord) throws WorkflowUserException {
        Actor actor = this.actorUtils.buildActor(pageTask.getPerformer());
        ActionDetails details = new ActionDetails();
        details.addDetail(ActionDetail.Type.TASK_NAME, pageTask.getName());
        details.addAll(this.buildStateActionDetails(state));
        Action action = new Action(new ActionType(ActionType.Type.TASK, ActionType.Subtype.TASK_DUE_DATE_DELETED), actor, details);
        return new Activity(TaskDueDateDeletionMapper.buildTarget((ContentEntityObject)abstractPage), dueDateRecord.getDate().getTime(), action);
    }
}

