/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetail;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.Target;
import com.comalatech.confluence.documentActivity.domain.entities.TargetAttachment;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.model.PageState;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GenericEventActivityMapper {
    protected final ActorUtils actorUtils;

    public GenericEventActivityMapper(ActorUtils actorUtils) {
        this.actorUtils = actorUtils;
    }

    public static Target buildTarget(long id, int version, String spaceKey, List<Attachment> pageAttachments) {
        Target target = new Target();
        target.setTargetId(id);
        target.setTargetVersion(version);
        target.setSpaceKey(spaceKey);
        if (pageAttachments != null && !pageAttachments.isEmpty()) {
            ArrayList<TargetAttachment> targetAttachments = new ArrayList<TargetAttachment>();
            for (Attachment attachment : pageAttachments) {
                TargetAttachment targetAttachment = new TargetAttachment();
                targetAttachment.setTargetAttachmentId(attachment.getId());
                targetAttachment.setTargetAttachmentVersion(attachment.getVersion());
                targetAttachments.add(targetAttachment);
            }
            target.setAttachmentList(targetAttachments);
        }
        return target;
    }

    public static Target buildTarget(ContentEntityObject content) {
        if (content == null) {
            return null;
        }
        String spaceKey = content instanceof AbstractPage ? ((AbstractPage)content).getSpaceKey() : null;
        return GenericEventActivityMapper.buildTarget(content.getId(), content.getVersion(), spaceKey, content.getAttachments());
    }

    protected ActionDetails buildStateActionDetails(PageState state) {
        ActionDetails stateDetails = new ActionDetails();
        if (state != null) {
            stateDetails.addDetail(ActionDetail.Type.STATE_NAME, state.getName());
            stateDetails.addDetail(ActionDetail.Type.STATE_ID, String.valueOf(state.getId()));
            stateDetails.addDetail(ActionDetail.Type.IS_PUBLISHED, String.valueOf(state.isPublished()));
        }
        return stateDetails;
    }

    protected ActionDetails buildApprovalsActionDetails(String approvalName, int approvalCheckId, String comment) {
        ActionDetails details = new ActionDetails();
        details.addDetail(ActionDetail.Type.APPROVAL_NAME, approvalName);
        details.addDetail(ActionDetail.Type.APPROVAL_ID, String.valueOf(approvalCheckId));
        if (comment != null && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)comment)) {
            details.addDetail(ActionDetail.Type.APPROVAL_COMMENT, comment);
        }
        return details;
    }

    protected ActionDetails buildRoleNameActionDetails(String roleName) {
        ActionDetails actionDetails = new ActionDetails();
        if (!StringUtils.isEmpty((String)roleName)) {
            actionDetails.addDetail(ActionDetail.Type.APPROVAL_ROLE, roleName);
        }
        return actionDetails;
    }
}

