/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.analytics;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.config.ConfigurationException;
import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.query.MacroUsageQuery;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.license.License;
import com.atlassian.license.LicenseManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.comalatech.confluence.analytics.AnalyticsManager;
import com.comalatech.confluence.analytics.BandanaContext;
import com.comalatech.confluence.analytics.ComalaSearch;
import com.comalatech.confluence.analytics.ContentSearchConfluence8CompatibilityBuilder;
import com.comalatech.confluence.analytics.FriendApps;
import com.comalatech.confluence.analytics.RSA;
import com.comalatech.confluence.analytics.StatField;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultAnalyticsManager
implements AnalyticsManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultAnalyticsManager.class);
    protected static String PUBLIC_KEY = "-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA8wQ8Zu4hOHHDrVVIJjlQ\n3+V2IYTSnFYyJQtYDXcdtGb29OYOwhnGhqaHsDqGeOwuSJlBmGyuH65NXBm6DWcs\n5L/8/pQRl83NDGDUWrxh0UZEDn4o2WaIXO3RmHaSNLVzzAUl3RdIWsix6j0KcB9A\n4Ne6U2CHYV5yb2pWsdjROumpQVQrStTFX80M+2MHI+I2rz6ZhCsW8zUhsuedFZHU\nUqU1m5gldccleuD/NvD1UvObN6OP1yixvNo7C6CvOZD/2HOuk2KfH1kaUahd7J1h\n52fkjb1I0qjlnCPVHDG1ywnlAvQO3EDzBXoYPWfCa4N2CU68vFeFGOl+vbcq1WG3\nJQIDAQAB\n-----END PUBLIC KEY-----";
    public static final String EMPTY_VALUE = "---";
    public static final String STAT_INSTANCE_ID = "instanceId";
    public static final String STAT_TIMESTAMP = "timestamp";
    public static final String STAT_COMALATECH_TOKEN = "comalatechToken";
    public static final String STAT_APP = "app";
    public static final String STAT_CONFLUENCE_VERSION = "hostVersion";
    public static final String STAT_TOTAL_SPACES = "totalSpaces";
    public static final String STAT_TOTAL_PAGES = "totalPages";
    public static final String STAT_TOTAL_VERSIONS = "totalVersions";
    public static final String STAT_LICENSE_TYPE = "licenseType";
    public static final String STAT_LICENSE_SIZE = "licenseSize";
    public static final String STAT_PLUGIN_LICENSE_TYPE = "pluginLicenseType";
    public static final String STAT_PLUGIN_LICENSE_SIZE = "pluginLicenseSize";
    public static final String STAT_PLUGIN_VERSION = "version";
    public static final String STAT_FRIEND_APPS = "friendApps";
    public static final int PLUGIN_LICENSE_UNDEFINED = -1;
    public static final String LICENSE_TYPE_INVALID = "INVALID";
    public static final String LICENSE_TYPE_EVALUATION = "EVALUATION";
    public static final String LICENSE_TYPE_PAID = "PAID";
    public static final String LICENSE_TYPE_ERROR = "ERROR";
    protected static final String BANDANA_CONTEXT = "_COMALATECH";
    protected final String BANDANA_ENABLED_KEY;
    protected final String BANDANA_STATS_KEY;
    protected final String BANDANA_PREFIX;
    private BandanaContext bandanaContext = null;
    protected BandanaManager bandanaManager;
    protected ConfluenceSidManager confluenceSidManager;
    protected SystemInformationService systemInformationService;
    protected PluginAccessor pluginAccessor;
    protected PluginLicenseManager pluginLicenseManager;
    protected SearchManager searchManager;

    public DefaultAnalyticsManager(@ComponentImport BandanaManager bandanaManager, @ComponentImport ConfluenceSidManager confluenceSidManager, @ComponentImport SystemInformationService systemInformationService, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport SearchManager searchManager) {
        this.bandanaManager = bandanaManager;
        this.confluenceSidManager = confluenceSidManager;
        this.systemInformationService = systemInformationService;
        this.pluginAccessor = pluginAccessor;
        this.pluginLicenseManager = pluginLicenseManager;
        this.searchManager = searchManager;
        this.BANDANA_PREFIX = pluginLicenseManager.getPluginKey();
        this.BANDANA_ENABLED_KEY = this.BANDANA_PREFIX + ".analytics.enabled";
        this.BANDANA_STATS_KEY = this.BANDANA_PREFIX + ".analytics.stats";
    }

    @Override
    public boolean isEnabled() {
        Object value = this.bandanaManager.getValue((com.atlassian.bandana.BandanaContext)this.getBandanaContext(), this.BANDANA_ENABLED_KEY);
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return true;
    }

    @Override
    public void setEnabled(boolean enable) {
        this.bandanaManager.setValue((com.atlassian.bandana.BandanaContext)this.getBandanaContext(), this.BANDANA_ENABLED_KEY, (Object)Boolean.toString(enable));
    }

    @Override
    public boolean isDebugEnabled() {
        return log.isDebugEnabled();
    }

    @Override
    public boolean isDevMode() {
        return this.systemInformationService.getConfluenceInfo().isDevMode();
    }

    @Override
    public String getPrefix() {
        return this.BANDANA_PREFIX;
    }

    @Override
    public boolean hasStats() {
        return this.bandanaManager.getValue((com.atlassian.bandana.BandanaContext)this.getBandanaContext(), this.BANDANA_STATS_KEY) != null;
    }

    @Override
    public Map<String, Object> popStats() {
        Map valuesMap = (Map)this.bandanaManager.getValue((com.atlassian.bandana.BandanaContext)this.getBandanaContext(), this.BANDANA_STATS_KEY);
        if (log.isDebugEnabled()) {
            log.debug("Popped stats: " + valuesMap);
        }
        return valuesMap;
    }

    @Override
    public void ackStats() {
        try {
            this.bandanaManager.removeValue((com.atlassian.bandana.BandanaContext)this.getBandanaContext(), this.BANDANA_STATS_KEY);
            if (log.isDebugEnabled()) {
                log.debug("Acked stats");
            }
        }
        catch (Exception ex) {
            log.error("Could not ack stats", (Throwable)ex);
        }
    }

    @Override
    public int countPagesWithMacro(String macroName) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{macroName})) {
            MacroUsageQuery searchQuery = new MacroUsageQuery(macroName);
            ComalaSearch search = GeneralUtil.getVersionNumber().startsWith(String.valueOf(8)) ? new ContentSearchConfluence8CompatibilityBuilder().getContentSearch((SearchQuery)searchQuery, null, 0, 1) : new ComalaSearch((SearchQuery)searchQuery, null, 0, 1);
            try {
                SearchResults searchResults = this.searchManager.search((ISearch)search);
                return searchResults.getUnfilteredResultsCount();
            }
            catch (InvalidSearchException e) {
                throw new RuntimeException("Error searching for pages containing the macro: " + macroName, e);
            }
        }
        return 0;
    }

    @Override
    public void resolveAnalytics() {
        if (!this.canResolveAnalytics()) {
            log.debug("resolveAnalytics not running as it's disabled");
            return;
        }
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        Arrays.stream(this.getStatFields()).forEach(f -> valuesMap.put(f.name, (String)f.processor.execute()));
        Arrays.asList(STAT_INSTANCE_ID, STAT_TIMESTAMP).forEach(field -> {
            if (!valuesMap.containsKey(field)) {
                throw new RuntimeException("No <" + field + "> field in provided statFields: it's mandatory");
            }
        });
        String token = "{ \"instanceId\": \"" + valuesMap.get(STAT_INSTANCE_ID) + "\", \"timestamp\": \"" + valuesMap.get(STAT_TIMESTAMP) + "\" }";
        String signature = this.encrypt(token);
        valuesMap.put(STAT_COMALATECH_TOKEN, signature);
        this.bandanaManager.setValue((com.atlassian.bandana.BandanaContext)this.getBandanaContext(), this.BANDANA_STATS_KEY, valuesMap);
        if (log.isDebugEnabled()) {
            log.debug("Recalculated stats: " + valuesMap);
        }
    }

    @Override
    public long getTimestampAnalyticsEntry(String bandanaKey) {
        Object bandanaEntry = this.bandanaManager.getValue((com.atlassian.bandana.BandanaContext)new ConfluenceBandanaContext(), bandanaKey);
        if (bandanaEntry != null && bandanaEntry instanceof Long) {
            return (Long)bandanaEntry;
        }
        return 0L;
    }

    @Override
    public void setTimestampAnalyticsEntry(String bandanaKey) {
        this.bandanaManager.setValue((com.atlassian.bandana.BandanaContext)new ConfluenceBandanaContext(), bandanaKey, (Object)System.currentTimeMillis());
    }

    @Override
    public Object getAnalyticsEntry(String bandanaKey) {
        return this.bandanaManager.getValue((com.atlassian.bandana.BandanaContext)new ConfluenceBandanaContext(), bandanaKey);
    }

    @Override
    public void setAnalyticsEntry(String bandanaKey, Object bandanaValue) {
        this.bandanaManager.setValue((com.atlassian.bandana.BandanaContext)new ConfluenceBandanaContext(), bandanaKey, bandanaValue);
    }

    protected BandanaContext getBandanaContext() {
        if (this.bandanaContext == null) {
            this.bandanaContext = new BandanaContext(BANDANA_CONTEXT);
        }
        return this.bandanaContext;
    }

    protected StatField[] getStatFields() {
        return (StatField[])ArrayUtils.addAll((Object[])this.getDefaultStatFields(), (Object[])this.getExtendedStatFields());
    }

    protected StatField[] getDefaultStatFields() {
        return new StatField[]{new StatField(STAT_INSTANCE_ID, () -> {
            try {
                return DigestUtils.md5Hex(this.confluenceSidManager.getSid());
            }
            catch (ConfigurationException ex) {
                log.error("Couldn't get Confluence Sid");
                return EMPTY_VALUE;
            }
        }), new StatField(STAT_TIMESTAMP, () -> new Date().getTime()), new StatField(STAT_APP, () -> this.getFriendApps().getOrDefault(this.pluginLicenseManager.getPluginKey(), EMPTY_VALUE)), new StatField(STAT_CONFLUENCE_VERSION, () -> GeneralUtil.getVersionNumber()), new StatField(STAT_TOTAL_SPACES, () -> this.systemInformationService.getUsageInfo().getTotalSpaces()), new StatField(STAT_TOTAL_PAGES, () -> this.systemInformationService.getUsageInfo().getCurrentContent()), new StatField(STAT_TOTAL_VERSIONS, () -> this.systemInformationService.getUsageInfo().getAllContent()), new StatField(STAT_LICENSE_SIZE, () -> {
            License license = LicenseManager.getInstance().getLicense("CONF");
            return license != null ? license.getUsers() : 0;
        }), new StatField(STAT_LICENSE_TYPE, () -> {
            License license = LicenseManager.getInstance().getLicense("CONF");
            return license != null ? license.getLicenseType().getNewLicenseTypeName() : EMPTY_VALUE;
        }), new StatField(STAT_PLUGIN_LICENSE_SIZE, () -> {
            if (this.pluginLicenseManager.getLicense().isDefined()) {
                return ((PluginLicense)this.pluginLicenseManager.getLicense().get()).getEdition().getOrElse((Object)0);
            }
            return -1;
        }), new StatField(STAT_PLUGIN_LICENSE_TYPE, () -> {
            if (this.pluginLicenseManager.getLicense().isDefined()) {
                PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
                if (license.isEvaluation()) {
                    return LICENSE_TYPE_EVALUATION;
                }
                if (license.getError().isDefined()) {
                    return LICENSE_TYPE_ERROR;
                }
                if (license.isValid()) {
                    return LICENSE_TYPE_PAID;
                }
            }
            return LICENSE_TYPE_INVALID;
        }), new StatField(STAT_PLUGIN_VERSION, () -> this.pluginAccessor.getPlugin(this.pluginLicenseManager.getPluginKey()).getPluginInformation().getVersion()), new StatField(STAT_FRIEND_APPS, () -> this.getFriendApps().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(this.pluginLicenseManager.getPluginKey())).filter(entry -> this.pluginAccessor.getPlugin((String)entry.getKey()) != null).map(entry -> (String)entry.getValue()).collect(Collectors.joining(",")))};
    }

    protected StatField[] getExtendedStatFields() {
        return new StatField[0];
    }

    protected Map<String, String> getFriendApps() {
        return FriendApps.getFriendApps();
    }

    protected String encrypt(String token) {
        try {
            return RSA.encrypt(token, RSA.getPublicKeyFromString(PUBLIC_KEY));
        }
        catch (IOException ioEx) {
            log.error("Public key not found", (Throwable)ioEx);
        }
        catch (GeneralSecurityException gsEx) {
            log.error("Security exception while encrypting", (Throwable)gsEx);
        }
        return null;
    }
}

