/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.listeners;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.ApprovalManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.events.ApprovalsResetEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentChangedEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentRemoveEvent;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApprovalPersistanceHandler {
    private static final Logger log = LoggerFactory.getLogger(ApprovalPersistanceHandler.class);
    protected final PageManager pageManager;
    protected final ApprovalAccessor approvalAccessor;
    protected final StateAccessor stateAccessor;
    protected final ApprovalManager approvalManager;
    protected final WorkflowConfigurationManager workflowConfigurationManager;
    protected final AttachmentManager attachmentManager;
    protected final EventPublisher eventPublisher;

    public ApprovalPersistanceHandler(PageManager pageManager, ApprovalManager approvalManager, ApprovalAccessor approvalAccessor, StateAccessor stateAccessor, WorkflowConfigurationManager workflowConfigurationManager, AttachmentManager attachmentManager, EventPublisher eventPublisher) {
        this.pageManager = pageManager;
        this.approvalAccessor = approvalAccessor;
        this.stateAccessor = stateAccessor;
        this.approvalManager = approvalManager;
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.attachmentManager = attachmentManager;
        this.eventPublisher = eventPublisher;
    }

    public void handle(PageUpdateEvent event) {
        PageState pageState;
        AbstractPage page = (AbstractPage)event.getContent();
        List<ApprovalCheck> approvalChecks = this.approvalAccessor.getApprovalChecks(page, pageState = this.stateAccessor.getLatestState(page));
        if (CollectionUtils.isEmpty(approvalChecks)) {
            return;
        }
        if (!this.workflowConfigurationManager.isPageUpdateApprovalReset(page.getSpaceKey())) {
            for (ApprovalCheck approvalCheck : approvalChecks) {
                if (log.isDebugEnabled()) {
                    log.debug("Updating page version, approval: " + approvalCheck.getName() + " page: " + page.getId() + " oldVersion: " + approvalCheck.getVersion() + " newVersion: " + page.getVersion());
                }
                approvalCheck.setVersion(page.getVersion());
                try {
                    this.approvalManager.updateApprovalCheck(page, approvalCheck);
                }
                catch (WorkflowException e) {
                    log.error("Error trying to update page version on approval.  Page: " + page + " approval: " + approvalCheck, (Throwable)e);
                }
            }
        } else {
            this.eventPublisher.publish((Object)new ApprovalsResetEvent(page, pageState));
        }
    }

    public void handle(WorkflowAttachmentEvent event) {
        if (!(event instanceof WorkflowAttachmentChangedEvent)) {
            PageState pageState;
            AbstractPage page = (AbstractPage)event.getContent();
            List<ApprovalCheck> approvalChecks = this.approvalAccessor.getApprovalChecks(page, pageState = this.stateAccessor.getLatestState(page));
            if (CollectionUtils.isEmpty(approvalChecks)) {
                return;
            }
            if (!this.workflowConfigurationManager.isPageUpdateApprovalReset(page.getSpaceKey())) {
                List latestAttachments = this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)page);
                if (event instanceof WorkflowAttachmentRemoveEvent) {
                    latestAttachments.remove(event.getAttachment());
                }
                for (ApprovalCheck approvalCheck : approvalChecks) {
                    if (log.isDebugEnabled()) {
                        log.debug("Updating checked attachments, approval: " + approvalCheck.getName() + " page: " + page.getId() + " oldAttachments: " + Arrays.asList(approvalCheck.getAttachments()) + " newAttachments: " + latestAttachments);
                    }
                    approvalCheck.setAttachments(latestAttachments);
                    try {
                        this.approvalManager.updateApprovalCheck(page, approvalCheck);
                    }
                    catch (WorkflowException e) {
                        log.error("Error trying to update page attachments on approval.  Page: " + page + " approval: " + approvalCheck, (Throwable)e);
                    }
                }
            } else {
                this.eventPublisher.publish((Object)new ApprovalsResetEvent(page, pageState));
            }
        }
    }
}

