/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.analytics;

import com.atlassian.upm.api.license.PluginLicenseManager;
import com.comalatech.confluence.analytics.StatField;
import com.comalatech.confluence.cloud.migration.model.assessment.MigrationAppAssessmentInfo;
import com.comalatech.confluence.cloud.migration.model.events.MigrationAnalyticsEvent;
import com.comalatech.confluence.cloud.migration.service.CloudMigrationAnalyticsService;
import java.util.ArrayList;
import java.util.List;

public class CloudMigrationAnalyticsGatherer {
    public static final String LATEST_CLOUD_MIGRATION_ACCESSED = "latestCloudMigrationAccess";
    public static final String STAT_CLOUD_MIGRATION_APP_ASSESSMENT = "cloudMigrationAppAssessment";
    private final CloudMigrationAnalyticsService cloudMigrationAnalyticsService;
    private final PluginLicenseManager pluginLicenseManager;

    public CloudMigrationAnalyticsGatherer(CloudMigrationAnalyticsService cloudMigrationAnalyticsService, PluginLicenseManager pluginLicenseManager) {
        this.cloudMigrationAnalyticsService = cloudMigrationAnalyticsService;
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public List<StatField> getAnalyticsFields() {
        ArrayList<StatField> fields = new ArrayList<StatField>();
        fields.add(this.retrieveAppAssessmentInfo());
        fields.add(this.retrieveLatestCloudMigrationAccess());
        return fields;
    }

    private StatField retrieveAppAssessmentInfo() {
        return new StatField(STAT_CLOUD_MIGRATION_APP_ASSESSMENT, () -> this.obtainCloudAppAssessment());
    }

    private StatField retrieveLatestCloudMigrationAccess() {
        return new StatField(LATEST_CLOUD_MIGRATION_ACCESSED, () -> this.obtainCloudAnalyticsEventTimestamp());
    }

    private Long obtainCloudAnalyticsEventTimestamp() {
        MigrationAnalyticsEvent migrationAnalyticsEvent = this.cloudMigrationAnalyticsService.getLastScreenEventType();
        if (migrationAnalyticsEvent != null) {
            return migrationAnalyticsEvent.getEventTimestamp();
        }
        return 0L;
    }

    private String obtainCloudAppAssessment() {
        MigrationAppAssessmentInfo migrationAppAssessmentInfo = this.cloudMigrationAnalyticsService.getAppAssessment(this.pluginLicenseManager.getPluginKey());
        if (migrationAppAssessmentInfo != null) {
            return migrationAppAssessmentInfo.getAssessmentStatus();
        }
        return "---";
    }
}

