/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.user.User;
import com.comalatech.confluence.dataextractor.ComalaPropertiesSetManager;
import com.comalatech.confluence.workflow.WorkflowUserSettingsManager;
import com.opensymphony.util.TextUtils;

public class WorkflowUserSettingsManagerImpl
implements WorkflowUserSettingsManager {
    protected final PersonalInformationManager personalInformationManager;
    protected final ComalaPropertiesSetManager contentPropertyManager;
    protected static final String INAPPNOTIFY_WATCHEDPAGES = "com.comalatech.confluence.workflow.inAppNotifyWatchedPages";

    public WorkflowUserSettingsManagerImpl(PersonalInformationManager personalInformationManager, ComalaPropertiesSetManager contentPropertyManager) {
        this.personalInformationManager = personalInformationManager;
        this.contentPropertyManager = contentPropertyManager;
    }

    @Override
    public boolean isInAppNotifyWatchedPages(ConfluenceUser user) {
        PersonalInformation pi = this.personalInformationManager.getOrCreatePersonalInformation((User)user);
        String notify = this.contentPropertyManager.getStringProperty((ContentEntityObject)pi, INAPPNOTIFY_WATCHEDPAGES);
        if (TextUtils.stringSet((String)notify)) {
            return Boolean.parseBoolean(notify);
        }
        return true;
    }

    @Override
    public void setInAppNotifyWatchedPages(ConfluenceUser user, boolean notify) {
        PersonalInformation pi = this.personalInformationManager.getOrCreatePersonalInformation((User)user);
        this.contentPropertyManager.setStringProperty((ContentEntityObject)pi, INAPPNOTIFY_WATCHEDPAGES, Boolean.toString(notify));
    }
}

