/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.RendererConfiguration;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.links.UrlLink;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.Entity;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.comalatech.confluence.util.FancyDateFormatter;
import com.comalatech.confluence.workflow.ApprovalCheckDecorator;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApprovalCheckDecorator
implements ApprovalCheckDecorator {
    private static final Logger log = LoggerFactory.getLogger(DefaultApprovalCheckDecorator.class);
    private static final String HISTORICVERSION_PREFIX = "/pages/viewpage.action?pageId=";
    private static final String PAGEDIFF_PREFIX = "/pages/diffpagesbyversion.action?pageId=";
    private static LocaleManager localeManager;
    private final FormatSettingsManager formatSettingsManager;
    private final UserAccessor userAccessor;
    private final PageManager pageManager;
    private final WikiStyleRenderer wikiStyleRenderer;
    private final SpaceManager spaceManager;
    private RendererConfiguration rendererConfiguration;

    public DefaultApprovalCheckDecorator(FormatSettingsManager formatSettingsManager, UserAccessor userAccessor, PageManager pageManager, WikiStyleRenderer wikiStyleRenderer, SpaceManager spaceManager) {
        this.formatSettingsManager = formatSettingsManager;
        this.userAccessor = userAccessor;
        this.pageManager = pageManager;
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.spaceManager = spaceManager;
        if (this.rendererConfiguration == null) {
            this.rendererConfiguration = (RendererConfiguration)ComponentLocator.getComponent(RendererConfiguration.class);
            if (this.rendererConfiguration == null) {
                this.rendererConfiguration = (RendererConfiguration)ContainerManager.getComponent((String)"rendererConfiguration");
            }
        }
    }

    @Override
    public String decorateUser(String userName) {
        return "<a href=\"" + this.rendererConfiguration.getWebAppContextPath() + "/display/~" + HtmlUtil.urlEncode((String)userName) + "\">" + HtmlUtil.htmlEncode((String)this.getUserFullName(userName)) + "</a>";
    }

    @Override
    public String decorateTimeDate(Date date) {
        return this.getDateFormatter().formatDateTime(date);
    }

    @Override
    public String decorateDatePretty(Date date) {
        return FancyDateFormatter.decorateDateTimePretty(date, false);
    }

    @Override
    public String decorateDateTimePretty(Date date) {
        return FancyDateFormatter.decorateDateTimePretty(date, true);
    }

    @Override
    public String decorateDateTimeFormal(Date date) {
        return ConfluenceActionSupport.getTextStatic((String)"approvalsworkflow.approvals.info.date.on", (Object[])new String[]{this.getDateFormatter().formatDateTime(date)});
    }

    @Override
    public UrlLink decorateMarkedVersion(AbstractPage page, int version, int approvalId, boolean upToDate) {
        try {
            if (upToDate) {
                return new UrlLink(this.rendererConfiguration.getWebAppContextPath() + HISTORICVERSION_PREFIX + page.getIdAsString(), ConfluenceActionSupport.getTextStatic((String)"current"));
            }
            AbstractPage vpage = this.pageManager.getPageByVersion(page, version);
            if (vpage == null) {
                return null;
            }
            return new UrlLink(this.rendererConfiguration.getWebAppContextPath() + HISTORICVERSION_PREFIX + vpage.getIdAsString() + "&approvalId=" + approvalId, "v." + version);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    @Override
    public String decorateDiff(AbstractPage page, int version) {
        if (page.getVersion() == version) {
            return null;
        }
        AbstractPage vpage = this.pageManager.getPageByVersion(page, version);
        if (vpage == null) {
            return null;
        }
        return "(<a href=\"" + this.rendererConfiguration.getWebAppContextPath() + PAGEDIFF_PREFIX + page.getIdAsString() + "&originalVersion=" + version + "&revisedVersion=" + page.getVersion() + "\">diff</a>)";
    }

    @Override
    public String getUserFullName(String userName) {
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        if (user == null) {
            return userName;
        }
        return user.getFullName();
    }

    @Override
    public String makeUserNamesList(String[] userNames, boolean or, boolean createLinks) {
        if (userNames == null) {
            return "";
        }
        String lastSeparator = or ? ConfluenceActionSupport.getTextStatic((String)"or.word") : ConfluenceActionSupport.getTextStatic((String)"and.word");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < userNames.length; ++i) {
            String userName = userNames[i];
            if (i == userNames.length - 1) {
                if (userNames.length > 1) {
                    sb.append(" ").append(lastSeparator.toLowerCase()).append(" ");
                }
            } else if (i > 0) {
                sb.append(", ");
            }
            if (createLinks) {
                sb.append(this.decorateUser(userName));
                continue;
            }
            sb.append(this.getUserFullName(userName));
        }
        return sb.toString();
    }

    @Override
    public String makeUsersAndGroupsList(Collection<Entity> userOrGroups, boolean or, boolean createLinks) {
        if (userOrGroups == null || userOrGroups.size() == 0) {
            return "";
        }
        String lastSeparator = or ? ConfluenceActionSupport.getTextStatic((String)"or.word") : ConfluenceActionSupport.getTextStatic((String)"and.word");
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (Entity userOrGroup : userOrGroups) {
            if (i == userOrGroups.size() - 1) {
                if (userOrGroups.size() > 1) {
                    sb.append(" ").append(lastSeparator.toLowerCase()).append(" ");
                }
            } else if (i > 0) {
                sb.append(", ");
            }
            if (createLinks) {
                sb.append(this.makeUserOrGroupLink(userOrGroup));
            } else {
                sb.append(this.makeUserOrGroupName(userOrGroup));
            }
            ++i;
        }
        return sb.toString();
    }

    private String makeUserOrGroupName(Entity entity) {
        if (entity instanceof ConfluenceUser) {
            return ((ConfluenceUser)entity).getFullName();
        }
        return this.decorateGroupName((Group)entity);
    }

    private String makeUserOrGroupLink(Entity entity) {
        if (entity instanceof ConfluenceUser) {
            return this.makeUserLink((ConfluenceUser)entity);
        }
        return this.decorateGroupName((Group)entity);
    }

    private String decorateGroupName(Group group) {
        return ConfluenceActionSupport.getTextStatic((String)"com.awp.group.members", (Object[])new String[]{group.getName()});
    }

    private String makeUserLink(ConfluenceUser user) {
        return "<a href=\"" + this.spaceManager.getPersonalSpace(user).getUrlPath() + "\">" + user.getFullName() + "</a>";
    }

    @Override
    public String render(String body, RenderContext renderContext) {
        return this.wikiStyleRenderer.convertWikiToXHtml(renderContext, body);
    }

    @Override
    public String getText(String id) {
        return ConfluenceActionSupport.getTextStatic((String)id);
    }

    @Override
    public String getText(String id, String parameter) {
        return ConfluenceActionSupport.getTextStatic((String)id, (Object[])new String[]{parameter});
    }

    @Override
    public String getText(String id, String[] parameters) {
        return ConfluenceActionSupport.getTextStatic((String)id, (Object[])parameters);
    }

    private DateFormatter getDateFormatter() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.userAccessor.getConfluenceUserPreferences((User)user).getDateFormatter(this.formatSettingsManager, DefaultApprovalCheckDecorator.getLocaleManager());
    }

    private static LocaleManager getLocaleManager() {
        if (localeManager == null) {
            localeManager = (LocaleManager)ContainerManager.getComponent((String)"localeManager");
        }
        return localeManager;
    }
}

