/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.storage;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.joda.time.DateTime;
import org.randombits.storage.ChainedStorage;
import org.randombits.storage.Storage;
import org.randombits.storage.StorageEvent;
import org.randombits.storage.StorageListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StorageUtils {
    private static Map<Storage, Synchronizer> synchros;

    private StorageUtils() {
    }

    public static Storage readOnlyStorage(Storage storage) {
        return new ChainedStorage(new Storage[]{storage}){

            public boolean isReadOnly() {
                return true;
            }
        };
    }

    public static void synchronize(Storage source, Storage target) {
        Synchronizer synchro = null;
        if (synchros == null) {
            synchros = new WeakHashMap<Storage, Synchronizer>();
        } else {
            synchro = synchros.get(source);
        }
        if (synchro == null) {
            synchro = new Synchronizer();
            synchros.put(source, synchro);
            source.addStorageListener(synchro);
        }
        synchro.addTarget(target);
    }

    public static void desynchronize(Storage source, Storage target) {
        Synchronizer synchro;
        if (synchros != null && (synchro = synchros.get(source)) != null) {
            synchro.removeTarget(target);
            if (synchro.getTargetCount() == 0) {
                synchros.remove(source);
                source.removeStorageListener(synchro);
            }
        }
    }

    public static Boolean findBoolean(Storage storage, String path, Boolean defaultValue) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            Boolean value = storage.getBoolean(names[names.length - 1], defaultValue);
            StorageUtils.unwalkPath(storage, names);
            return value;
        }
        return defaultValue;
    }

    public static void setBoolean(Storage storage, String path, Boolean value) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            storage.setBoolean(names[names.length - 1], value);
            StorageUtils.unwalkPath(storage, names);
        }
    }

    public static boolean findBoolean(Storage storage, String path, boolean defaultValue) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            boolean value = storage.getBoolean(names[names.length - 1], defaultValue);
            StorageUtils.unwalkPath(storage, names);
            return value;
        }
        return defaultValue;
    }

    public static void setBoolean(Storage storage, String path, boolean value) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            storage.setBoolean(names[names.length - 1], value);
            StorageUtils.unwalkPath(storage, names);
        }
    }

    public static Date findDate(Storage storage, String path, Date defaultValue) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            Date value = storage.getDate(names[names.length - 1], defaultValue);
            StorageUtils.unwalkPath(storage, names);
            return value;
        }
        return defaultValue;
    }

    public static void setDate(Storage storage, String path, Date value) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            storage.setDate(names[names.length - 1], value);
            StorageUtils.unwalkPath(storage, names);
        }
    }

    public static DateTime findDateTime(Storage storage, String path, DateTime defaultValue) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            DateTime value = storage.getDateTime(names[names.length - 1], defaultValue);
            StorageUtils.unwalkPath(storage, names);
            return value;
        }
        return defaultValue;
    }

    public static void setDateTime(Storage storage, String path, DateTime value) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            storage.setDateTime(names[names.length - 1], value);
            StorageUtils.unwalkPath(storage, names);
        }
    }

    public static Double findDouble(Storage storage, String path, Double defaultValue) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            Double value = storage.getDouble(names[names.length - 1], defaultValue);
            StorageUtils.unwalkPath(storage, names);
            return value;
        }
        return defaultValue;
    }

    public static void setDouble(Storage storage, String path, double value) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            storage.setDouble(names[names.length - 1], value);
            StorageUtils.unwalkPath(storage, names);
        }
    }

    public static double findDouble(Storage storage, String path, double defaultValue) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            double value = storage.getDouble(names[names.length - 1], defaultValue);
            StorageUtils.unwalkPath(storage, names);
            return value;
        }
        return defaultValue;
    }

    public static void setDouble(Storage storage, String path, Double value) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            storage.setDouble(names[names.length - 1], value);
            StorageUtils.unwalkPath(storage, names);
        }
    }

    public static Integer findInteger(Storage storage, String path, Integer defaultValue) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            Integer value = storage.getInteger(names[names.length - 1], defaultValue);
            StorageUtils.unwalkPath(storage, names);
            return value;
        }
        return defaultValue;
    }

    public static void setInteger(Storage storage, String path, Integer value) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            storage.setInteger(names[names.length - 1], value);
            StorageUtils.unwalkPath(storage, names);
        }
    }

    public static int findInteger(Storage storage, String path, int defaultValue) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            int value = storage.getInteger(names[names.length - 1], defaultValue);
            StorageUtils.unwalkPath(storage, names);
            return value;
        }
        return defaultValue;
    }

    public static void setInteger(Storage storage, String path, int value) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            storage.setInteger(names[names.length - 1], value);
            StorageUtils.unwalkPath(storage, names);
        }
    }

    public static Long findLong(Storage storage, String path, Long defaultValue) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            Long value = storage.getLong(names[names.length - 1], defaultValue);
            StorageUtils.unwalkPath(storage, names);
            return value;
        }
        return defaultValue;
    }

    public static void setLong(Storage storage, String path, Long value) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            storage.setLong(names[names.length - 1], value);
            StorageUtils.unwalkPath(storage, names);
        }
    }

    public static long findLong(Storage storage, String path, long defaultValue) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            long value = storage.getLong(names[names.length - 1], defaultValue);
            StorageUtils.unwalkPath(storage, names);
            return value;
        }
        return defaultValue;
    }

    public static void setLong(Storage storage, String path, long value) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            storage.setLong(names[names.length - 1], value);
            StorageUtils.unwalkPath(storage, names);
        }
    }

    public static Number findNumber(Storage storage, String path, Number defaultValue) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            Number value = storage.getNumber(names[names.length - 1], defaultValue);
            StorageUtils.unwalkPath(storage, names);
            return value;
        }
        return defaultValue;
    }

    public static Object findObject(Storage storage, String path, Object defaultValue) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            Object value = storage.getObject(names[names.length - 1], defaultValue);
            StorageUtils.unwalkPath(storage, names);
            return value;
        }
        return defaultValue;
    }

    public static void setObject(Storage storage, String path, Object value) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            storage.setObject(names[names.length - 1], value);
            StorageUtils.unwalkPath(storage, names);
        }
    }

    public static List<?> findObjectList(Storage storage, String path, List<?> defaultValue) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            List<?> value = storage.getObjectList(names[names.length - 1], defaultValue);
            StorageUtils.unwalkPath(storage, names);
            return value;
        }
        return defaultValue;
    }

    public static void setObjectList(Storage storage, String path, List<?> value) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            storage.setObjectList(names[names.length - 1], value);
            StorageUtils.unwalkPath(storage, names);
        }
    }

    public static String findString(Storage storage, String path, String defaultValue) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            String value = storage.getString(names[names.length - 1], defaultValue);
            StorageUtils.unwalkPath(storage, names);
            return value;
        }
        return defaultValue;
    }

    public static void setString(Storage storage, String path, String value) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            storage.setString(names[names.length - 1], value);
            StorageUtils.unwalkPath(storage, names);
        }
    }

    public static String[] findStringArray(Storage storage, String path, String[] defaultValue) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            String[] value = storage.getStringArray(names[names.length - 1], defaultValue);
            StorageUtils.unwalkPath(storage, names);
            return value;
        }
        return defaultValue;
    }

    public static void setStringArray(Storage storage, String path, String[] value) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            storage.setStringArray(names[names.length - 1], value);
            StorageUtils.unwalkPath(storage, names);
        }
    }

    public static Set<String> findStringSet(Storage storage, String path, Set<String> defaultValue) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            Set<String> value = storage.getStringSet(names[names.length - 1], defaultValue);
            StorageUtils.unwalkPath(storage, names);
            return value;
        }
        return defaultValue;
    }

    public static void setStringSet(Storage storage, String path, Set<String> value) {
        String[] names = StorageUtils.walkPath(storage, path);
        if (names != null) {
            storage.setStringSet(names[names.length - 1], value);
            StorageUtils.unwalkPath(storage, names);
        }
    }

    private static void unwalkPath(Storage storage, String[] names) {
        for (int i = 0; i < names.length - 1; ++i) {
            storage.closeBox();
        }
    }

    private static String[] walkPath(Storage storage, String path) {
        String[] names;
        if (path != null && (names = path.split("\\.")).length > 0) {
            for (int i = 0; i < names.length - 1; ++i) {
                storage.openBox(names[i]);
            }
            return names;
        }
        return null;
    }

    private static class Synchronizer
    implements StorageListener {
        private Set<Storage> targets = new HashSet<Storage>();

        public void addTarget(Storage target) {
            this.targets.add(target);
        }

        public void removeTarget(Storage target) {
            this.targets.remove(target);
        }

        public void boxOpened(StorageEvent evt) {
            for (Storage storage : this.targets) {
                storage.openBox(evt.getKey());
            }
        }

        public void boxClosed(StorageEvent evt) {
            for (Storage storage : this.targets) {
                storage.closeBox();
            }
        }

        public int getTargetCount() {
            return this.targets.size();
        }
    }
}

