/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.param.format;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.randombits.confluence.filtering.param.BaseParameter;
import org.randombits.confluence.filtering.param.ParameterException;
import org.randombits.confluence.support.MacroInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateFormatParameter
extends BaseParameter<DateFormat> {
    private static final String FORMAT_PARAM = "format";
    private static final String LONG_FORMAT = "long";
    private static final String MEDIUM_FORMAT = "medium";
    private static final String SHORT_FORMAT = "short";
    private static final String DEFAULT_FORMAT = "default";

    public DateFormatParameter() {
        this(DEFAULT_FORMAT);
    }

    public DateFormatParameter(String defaultValue) {
        super(defaultValue, FORMAT_PARAM);
    }

    public DateFormat findDateFormat(MacroInfo info) throws ParameterException {
        return (DateFormat)this.findValue(info);
    }

    @Override
    protected DateFormat findObject(String paramValue, MacroInfo info) throws ParameterException {
        return this.getDateFormat(paramValue);
    }

    private DateFormat getDateFormat(String format) {
        if (format == null || DEFAULT_FORMAT.equalsIgnoreCase(format)) {
            return DateFormat.getInstance();
        }
        if (MEDIUM_FORMAT.equalsIgnoreCase(format)) {
            return DateFormat.getDateTimeInstance(2, 2);
        }
        if (SHORT_FORMAT.equalsIgnoreCase(format)) {
            return DateFormat.getDateTimeInstance(3, 3);
        }
        if (LONG_FORMAT.equalsIgnoreCase(format)) {
            return DateFormat.getDateTimeInstance(1, 1);
        }
        return new SimpleDateFormat(format);
    }
}

