/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.criteria;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.randombits.confluence.filtering.criteria.Criterion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CriteriaUtils {
    public static <T> void filterCollectionContents(Collection<T> collection, Criterion criterion) {
        Iterator<T> i = collection.iterator();
        while (i.hasNext()) {
            T value = i.next();
            if (criterion.matches(value)) continue;
            i.remove();
        }
    }

    public static <T> List<T> filterIntoList(Iterable<T> iterable, Criterion criterion) {
        return CriteriaUtils.filterIntoList(iterable.iterator(), criterion);
    }

    public static <T> List<T> filterIntoList(Iterator<T> iterator, Criterion criterion) {
        ArrayList<T> values = new ArrayList<T>();
        while (iterator.hasNext()) {
            T value = iterator.next();
            if (!criterion.matches(value)) continue;
            values.add(value);
        }
        return values;
    }

    public static <T> Iterator<T> filterIntoIterator(Iterable<T> iterable, Criterion criterion) {
        return CriteriaUtils.filterIntoIterator(iterable.iterator(), criterion);
    }

    public static <T> Iterator<T> filterIntoIterator(Iterator<T> iterator, final Criterion criterion) {
        return new FilterIterator(iterator, new Predicate(){

            public boolean evaluate(Object value) {
                return criterion.matches(value);
            }
        });
    }
}

