/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflowreports.ActivityManager;
import com.comalatech.confluence.workflowreports.ReportDateFormatter;
import com.comalatech.confluence.workflowreports.model.ActivityReportEntry;
import com.comalatech.confluence.workflowreports.model.ActivityReportOptions;
import java.util.List;

public class ViewPageActivityAction
extends ConfluenceActionSupport {
    public static final String CHART = "chart";
    private long pageId;
    private AbstractPage page;
    private ActivityReportOptions options;
    private List<ActivityReportEntry> activityReportEntries;
    private ReportDateFormatter dateFormatter;
    private ActivityManager activityManager;
    private PageManager pageManager;
    private WorkflowPermissionManager workflowPermissionManager;
    private WorkflowConfigurationManager workflowConfigurationManager;
    private String workflowAuthor;
    private String workflowLogo;

    public String execute() throws Exception {
        this.page = this.pageManager.getAbstractPage(this.pageId);
        this.options = new ActivityReportOptions(false, false, true, false, false, true, 20);
        if (this.page == null || !this.workflowPermissionManager.canViewDrafts(this.page, AuthenticatedUserThreadLocal.get())) {
            return "error";
        }
        this.workflowAuthor = this.workflowConfigurationManager.getConfiguration().getWorkflowAuthor();
        this.workflowLogo = this.workflowConfigurationManager.getConfiguration().getWorkflowLogo();
        this.activityReportEntries = this.activityManager.getActivityReport(this.page, this.options);
        return "success";
    }

    public long getPageId() {
        return this.pageId;
    }

    public AbstractPage getPage() {
        return this.page;
    }

    public ActivityReportOptions getOptions() {
        return this.options;
    }

    public List<ActivityReportEntry> getActivityReportEntries() {
        return this.activityReportEntries;
    }

    public ReportDateFormatter getReportDateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new ReportDateFormatter(this.getLocaleManager());
        }
        return this.dateFormatter;
    }

    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    public void setActivityManager(ActivityManager activityManager) {
        this.activityManager = activityManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setWorkflowPermissionManager(WorkflowPermissionManager workflowPermissionManager) {
        this.workflowPermissionManager = workflowPermissionManager;
    }

    public void setWorkflowConfigurationManager(WorkflowConfigurationManager workflowConfigurationManager) {
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    public String getWorkflowAuthor() {
        return this.workflowAuthor;
    }

    public String getWorkflowLogo() {
        return this.workflowLogo;
    }
}

