/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.ipc;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.macros.actions.IpcMacro;
import com.comalatech.confluence.workflow.model.Approval;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ApprovalsNamesMacro
extends IpcMacro {
    public static final String PARAM_SPACEKEY = "spacekey";
    private WorkflowAccessor workflowAccessor;

    @Override
    protected String getName() {
        return "approvals-names";
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        this.checkRunMode(renderContext);
        String spaceKey = (String)parameters.get(PARAM_SPACEKEY);
        List<Approval> approvals = this.workflowAccessor.getAllApprovalsForSpace(spaceKey);
        ArrayList<String> approvalsNames = new ArrayList<String>(approvals.size());
        for (Approval approval : approvals) {
            approvalsNames.add(approval.getName());
        }
        renderContext.getParams().put("approvalsnames", approvalsNames);
        return null;
    }

    public void setWorkflowAccessor(WorkflowAccessor workflowAccessor) {
        this.workflowAccessor = workflowAccessor;
    }
}

