/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.LinkRenderer;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.workflow.macros.AbstractAttachmentMacro;
import java.util.Map;

public class AttachmentMacro
extends AbstractAttachmentMacro {
    private LinkRenderer linkRenderer;

    protected String render(AbstractPage page, AbstractAttachmentMacro.Parameters parameters, RenderContext renderContext) throws MacroException {
        SimpleAttachmentLink link = new SimpleAttachmentLink(parameters);
        return this.linkRenderer.renderLink((Link)link, renderContext);
    }

    public String execute(Map parametersMap, String body, RenderContext renderContext) throws MacroException {
        try {
            AbstractPage page = (AbstractPage)((PageContext)renderContext).getEntity();
            AbstractAttachmentMacro.Parameters parameters = this.parseParameters(parametersMap);
            this.loadAttachment(page, parameters);
            return this.render(page, parameters, renderContext);
        }
        catch (MacroException e) {
            return "<span class=\"error\">" + HtmlUtil.htmlEncode((String)e.getMessage()) + "</span>";
        }
    }

    public void setLinkRenderer(LinkRenderer linkRenderer) {
        this.linkRenderer = linkRenderer;
    }

    private class SimpleAttachmentLink
    extends Link {
        public SimpleAttachmentLink(AbstractAttachmentMacro.Parameters parameters) {
            super("");
            this.url = parameters.attachment.getDownloadPath();
            this.title = parameters.getTitle();
            this.linkBody = parameters.getLinkBody();
            this.relativeUrl = true;
            this.iconName = "attachment";
        }
    }
}

