/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.events;

import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.workflow.events.InternalApprovalEvent;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.workflow.model.Approval;
import com.comalatech.workflow.model.Rejection;

public class PageApprovalEvent
extends PageEvent
implements InternalApprovalEvent {
    private ApprovalCheck approvalCheck;
    private boolean partial;
    private PageState state;

    public PageApprovalEvent(Object src, Page page, PageState pageState, ApprovalCheck approvalCheck, boolean partial) {
        super(src, page);
        this.approvalCheck = approvalCheck;
        this.partial = partial;
        this.state = pageState;
    }

    @Override
    public boolean isPartial() {
        return this.partial;
    }

    @Override
    public PageState getState() {
        return this.state;
    }

    public Approval getApproval() {
        return this.approvalCheck.getLastApproval();
    }

    public Rejection getRejection() {
        return this.approvalCheck.getLastRejection();
    }

    @Override
    public ApprovalCheck getApprovalCheck() {
        return this.approvalCheck;
    }

    @Override
    public String getApprovalName() {
        return this.approvalCheck.getName();
    }

    @Override
    public AbstractPage getAbstractPage() {
        return this.getPage();
    }

    public String toString() {
        if (this.approvalCheck == null || this.getContent() == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (this.approvalCheck != null && this.approvalCheck.getLastApprover() != null) {
            sb.append(TimerUtils.logDate(this.approvalCheck.getLastApprover().getDate()));
        }
        sb.append(" ").append(this.getContent());
        sb.append(" ").append(this.approvalCheck.lastActivityToString());
        if (this.partial) {
            sb.append(" (partial)");
        }
        return sb.toString();
    }
}

