/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.audit;

import com.atlassian.confluence.api.model.audit.AffectedObject;
import com.atlassian.confluence.api.model.audit.AuditRecord;
import com.atlassian.confluence.api.model.audit.ChangedValue;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.audit.AuditService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.RequestCacheThreadLocal;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.audit.AuditLogRecordConverter;
import com.comalatech.confluence.workflow.audit.dao.WorkflowAuditLogDao;
import com.comalatech.confluence.workflow.audit.events.GlobalAuditHistoryCleardImpl;
import com.comalatech.confluence.workflow.audit.events.SpaceAuditHistoryClearedImpl;
import com.comalatech.confluence.workflow.audit.model.WorkflowAffectedObject;
import com.comalatech.confluence.workflow.audit.model.WorkflowAuditRecord;
import com.comalatech.confluence.workflow.audit.model.WorkflowChangedValue;
import com.comalatech.workflow.audit.AuditRecord;
import com.comalatech.workflow.audit.WorkflowAuditService;
import com.google.common.base.Joiner;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorkflowAuditService
implements WorkflowAuditService {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowAuditService.class);
    private static final String WORKFLOW_CATEGORY = "audit.logging.category.comala.workflows";
    private final int CONFLUENCE_BUILD_7_5 = 8501;
    protected final WorkflowConfigurationManager configurationManager;
    protected final EventPublisher eventPublisher;
    protected final SpaceManager spaceManager;
    protected final BootstrapManager bootstrapManager;
    protected final UserAccessor userAccessor;
    protected final AuditService auditService;
    protected final WorkflowAuditLogDao workflowAuditLogDao;

    public DefaultWorkflowAuditService(WorkflowConfigurationManager configurationManager, EventPublisher eventPublisher, SpaceManager spaceManager, BootstrapManager bootstrapManager, UserAccessor userAccessor, AuditService auditService, WorkflowAuditLogDao workflowAuditLogDao) {
        this.configurationManager = configurationManager;
        this.eventPublisher = eventPublisher;
        this.spaceManager = spaceManager;
        this.bootstrapManager = bootstrapManager;
        this.userAccessor = userAccessor;
        this.auditService = auditService;
        this.workflowAuditLogDao = workflowAuditLogDao;
    }

    @Override
    public void addRecord(AuditRecord auditRecord) {
        if (this.auditService != null) {
            if (auditRecord.getNewValues() == null || auditRecord.getNewValues() != null && (!auditRecord.getNewValues().containsKey("value") || auditRecord.getNewValues().containsKey("value") && StringUtils.isNotBlank((String)auditRecord.getNewValues().get("value")))) {
                this.saveAuditRecord(AuditLogRecordConverter.convertToWorkflowAuditRecord(auditRecord, this.userAccessor));
            }
        } else if (Boolean.TRUE.equals(this.configurationManager.isAuditLoggingEnabled())) {
            this.workflowAuditLogDao.saveAuditLogRecord(auditRecord);
        }
    }

    public boolean saveAuditRecord(WorkflowAuditRecord workflowAuditRecord) {
        com.atlassian.confluence.api.model.audit.AuditRecord auditRecord = this.createAuditRecordFrom(workflowAuditRecord);
        ValidationResult validationResult = this.auditService.validator().validateCreate(auditRecord);
        if (validationResult.isValid()) {
            try {
                this.auditService.storeRecord(auditRecord);
            }
            catch (ServiceException e) {
                log.error("saveAuditRecord failed: " + e.getMessage());
                return false;
            }
        } else {
            log.error("saveAuditRecord failed: " + validationResult.getErrors());
            return false;
        }
        return true;
    }

    private com.atlassian.confluence.api.model.audit.AuditRecord createAuditRecordFrom(WorkflowAuditRecord workflowAuditRecord) {
        ConfluenceUser user = workflowAuditRecord.getAuthor();
        User author = user == null ? null : new User(null, user.getName(), user.getFullName(), user.getKey());
        AuditRecord.Builder auditRecordBuilder = com.atlassian.confluence.api.model.audit.AuditRecord.builder().author(author).category(ConfluenceActionSupport.getTextStatic((String)WORKFLOW_CATEGORY)).createdDate(workflowAuditRecord.getCreationDate()).description(workflowAuditRecord.getDescription()).summary(workflowAuditRecord.getSummary()).remoteAddress(this.getRemoteAddress()).isSysAdmin(true);
        List<WorkflowChangedValue> workflowChangedValues = workflowAuditRecord.getChangedValues();
        if (workflowChangedValues != null && !workflowChangedValues.isEmpty()) {
            ArrayList<ChangedValue> changedValues = new ArrayList<ChangedValue>();
            for (WorkflowChangedValue workflowChangedValue : workflowChangedValues) {
                ChangedValue changedValue = ChangedValue.builder().name(workflowChangedValue.getName()).oldValue(workflowChangedValue.getOldValue()).newValue(workflowChangedValue.getNewValue()).build();
                changedValues.add(changedValue);
            }
            auditRecordBuilder.changedValues(changedValues);
        }
        this.setAffectedObjectAndAssociatedObjects(auditRecordBuilder, workflowAuditRecord);
        com.atlassian.confluence.api.model.audit.AuditRecord auditRecord = auditRecordBuilder.build();
        return auditRecord;
    }

    private void setAffectedObjectAndAssociatedObjects(AuditRecord.Builder auditRecordBuilder, WorkflowAuditRecord workflowAuditRecord) {
        WorkflowAffectedObject workflowAffectedObject = workflowAuditRecord.getAffectedObject();
        Set<WorkflowAffectedObject> workflowAssociatedObjects = workflowAuditRecord.getAssociatedObjects();
        if (workflowAffectedObject != null) {
            AffectedObject affectedObject = this.buildAffectedObject(workflowAffectedObject);
            auditRecordBuilder.affectedObject(affectedObject);
        } else if (!this.isPreConfluence75() && workflowAssociatedObjects != null && !workflowAssociatedObjects.isEmpty()) {
            WorkflowAffectedObject workflowAffectedObjectFromAssociatedObjects = workflowAssociatedObjects.iterator().next();
            workflowAssociatedObjects.remove(workflowAffectedObjectFromAssociatedObjects);
            AffectedObject affectedObject = this.buildAffectedObject(workflowAffectedObjectFromAssociatedObjects);
            auditRecordBuilder.affectedObject(affectedObject);
        }
        if (workflowAssociatedObjects != null && !workflowAssociatedObjects.isEmpty()) {
            HashSet<AffectedObject> associatedObjects = new HashSet<AffectedObject>();
            for (WorkflowAffectedObject workflowAssociatedObject : workflowAssociatedObjects) {
                AffectedObject affectedObject = this.buildAffectedObject(workflowAssociatedObject);
                associatedObjects.add(affectedObject);
            }
            auditRecordBuilder.associatedObjects(associatedObjects);
        }
    }

    private AffectedObject buildAffectedObject(WorkflowAffectedObject workflowAffectedObject) {
        AffectedObject affectedObject = AffectedObject.builder().name(workflowAffectedObject.getName()).objectType(workflowAffectedObject.getObjectType()).build();
        return affectedObject;
    }

    private boolean isPreConfluence75() {
        int buildNumber = Integer.valueOf(GeneralUtil.getBuildNumber());
        return buildNumber < 8501;
    }

    private String getRemoteAddress() {
        String proxyAddresses = RequestCacheThreadLocal.getXForwardedFor();
        String remoteAddress = RequestCacheThreadLocal.getRemoteAddress();
        if (proxyAddresses == null) {
            return remoteAddress;
        }
        return Joiner.on((char)',').join((Object)proxyAddresses, (Object)remoteAddress, new Object[0]);
    }

    @Override
    public List<AuditRecord> getRecords(@Nullable String spaceKey) {
        return this.workflowAuditLogDao.getAuditLogRecords(spaceKey);
    }

    public void removeAllRecords(@Nullable String spaceKey) {
        if (log.isInfoEnabled()) {
            log.info("Deleting Workflow Admin Audit Records for space: " + spaceKey);
        }
        this.workflowAuditLogDao.removeAllRecords(spaceKey);
        if (TextUtils.stringSet((String)spaceKey)) {
            Space space = this.spaceManager.getSpace(spaceKey);
            this.eventPublisher.publish((Object)new SpaceAuditHistoryClearedImpl(space));
        } else {
            this.eventPublisher.publish((Object)new GlobalAuditHistoryCleardImpl());
        }
    }
}

