/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.repository;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.migration.app.check.CheckResult;
import com.atlassian.migration.app.check.CheckResultBuilder;
import com.atlassian.migration.app.check.CheckSpec;
import com.atlassian.migration.app.check.CheckStatus;
import com.atlassian.migration.app.check.Container;
import com.atlassian.migration.app.check.CsvFileContent;
import com.atlassian.migration.app.check.MigrationPlanContext;
import com.atlassian.migration.app.check.PreMigrationCheckRepository;
import com.comalatech.confluence.cloud.migration.usecases.contracts.ValidatePreFlightCheck;
import com.comalatech.confluence.workflow.accesor.entity.ContentRestrictionWorkflowRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentManagementPreCheckRepository
implements PreMigrationCheckRepository {
    private static final Logger log = LoggerFactory.getLogger(DocumentManagementPreCheckRepository.class);
    private static final String COMALA_CHECK_KEY = "comalatech.migration.preflight.check";
    private static final String RESTRICTIONS_CHECK = "restrictions-check";
    private static final String RESTRICTIONS_STEP_TO_RESOLVE_WARNING = "steps-to-resolve-restrictions-found";
    private static final String RESTRICTIONS_STEP_TO_RESOLVE_ERROR = "steps-to-resolve-restrictions-error";
    private final ValidatePreFlightCheck validatePreFlightCheck;

    public DocumentManagementPreCheckRepository(ValidatePreFlightCheck validatePreFlightCheck) {
        this.validatePreFlightCheck = validatePreFlightCheck;
    }

    @Override
    public Set<CheckSpec> getAvailableChecks() {
        HashSet<CheckSpec> checks = new HashSet<CheckSpec>();
        try {
            checks.add(this.createRestrictionsCheck());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return checks;
    }

    @Override
    public CheckResult executeCheck(String checkId, MigrationPlanContext migrationPlanContext) {
        log.info("Running checks for plan {}", (Object)migrationPlanContext.getPlanName());
        log.info("Context of the migration: {}", (Object)Arrays.toString(migrationPlanContext.getContainers().toArray()));
        switch (checkId) {
            case "restrictions-check": {
                return this.checkContentRestrictions(migrationPlanContext.getContainers());
            }
        }
        throw new IllegalStateException("Unknown check: " + checkId);
    }

    private CheckSpec createRestrictionsCheck() {
        CheckSpec restrictionsCheck = new CheckSpec(RESTRICTIONS_CHECK, ConfluenceActionSupport.getTextStatic((String)"comalatech.migration.preflight.check.title"), this.buildStepsToResolveTemplates());
        List<String> validationErrors = restrictionsCheck.validate();
        if (!validationErrors.isEmpty()) {
            log.warn("Validation errors found: " + validationErrors);
        }
        return restrictionsCheck;
    }

    private CheckResult checkContentRestrictions(Set<Container> containers) {
        try {
            CheckResultBuilder builder = CheckResultBuilder.resultBuilder(CheckStatus.SUCCESS);
            List<String> spaceKeys = containers.stream().map(Container::getId).collect(Collectors.toList());
            List<ContentRestrictionWorkflowRecord> records = this.validatePreFlightCheck.getContentWithRestrictions(spaceKeys);
            if (!records.isEmpty()) {
                CsvFileContent csvFile = this.generateCSVFile(records);
                builder = CheckResultBuilder.resultBuilder(CheckStatus.WARNING);
                builder.withStepsToResolveKey(RESTRICTIONS_STEP_TO_RESOLVE_WARNING);
                builder.withCsvFileContent(csvFile);
            }
            return builder.build();
        }
        catch (Exception e) {
            log.error("checkContentRestrictions - Exception: {}", (Object)e.getMessage(), (Object)e);
            return CheckResultBuilder.resultBuilder(CheckStatus.CHECK_EXECUTION_ERROR).withStepsToResolveKey(RESTRICTIONS_STEP_TO_RESOLVE_ERROR).build();
        }
    }

    private Map<String, String> buildStepsToResolveTemplates() {
        HashMap<String, String> stepsToResolve = new HashMap<String, String>();
        stepsToResolve.put(RESTRICTIONS_STEP_TO_RESOLVE_WARNING, "<paragraph>" + ConfluenceActionSupport.getTextStatic((String)"comalatech.migration.preflight.check.warning.paragraph") + "</> <ordered-item>" + ConfluenceActionSupport.getTextStatic((String)"comalatech.migration.preflight.check.warning.orderedItem1") + "</><ordered-item>" + ConfluenceActionSupport.getTextStatic((String)"comalatech.migration.preflight.check.warning.orderedItem2") + "</><ordered-item>" + ConfluenceActionSupport.getTextStatic((String)"comalatech.migration.preflight.check.warning.orderedItem3") + "</><ordered-item>" + ConfluenceActionSupport.getTextStatic((String)"comalatech.migration.preflight.check.warning.orderedItem4") + "</>");
        stepsToResolve.put(RESTRICTIONS_STEP_TO_RESOLVE_ERROR, "<paragraph>" + ConfluenceActionSupport.getTextStatic((String)"comalatech.migration.preflight.check.error.paragraph") + "</>");
        return stepsToResolve;
    }

    private CsvFileContent generateCSVHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        for (int i = 1; i <= 9; ++i) {
            headers.add(ConfluenceActionSupport.getTextStatic((String)("comalatech.migration.preflight.check.csv.header" + i)));
        }
        return new CsvFileContent(headers);
    }

    private CsvFileContent generateCSVContent(CsvFileContent csvFileContent, List<ContentRestrictionWorkflowRecord> records) {
        Map<String, Map<Long, Map<String, Map<String, List<ContentRestrictionWorkflowRecord>>>>> groupByContent = records.stream().collect(Collectors.groupingBy(ContentRestrictionWorkflowRecord::getSpaceKey, Collectors.groupingBy(ContentRestrictionWorkflowRecord::getContentId, Collectors.groupingBy(ContentRestrictionWorkflowRecord::getTitle, Collectors.groupingBy(ContentRestrictionWorkflowRecord::getState)))));
        groupByContent.forEach((spaceKey, contents) -> contents.forEach((contentId, titles) -> titles.forEach((titleKey, states) -> states.forEach((stateName, restrictions) -> {
            HashSet<String> viewUsers = new HashSet<String>();
            HashSet<String> viewGroups = new HashSet<String>();
            HashSet<String> editUsers = new HashSet<String>();
            HashSet<String> editGroups = new HashSet<String>();
            boolean inheritedRestrictions = false;
            for (ContentRestrictionWorkflowRecord restriction : restrictions) {
                inheritedRestrictions = restriction.isInheritedRestrictions();
                if (restriction.getPermissionType() == null) continue;
                switch (restriction.getPermissionType()) {
                    case "View": {
                        if (restriction.getUsername() != null) {
                            viewUsers.add(restriction.getUsername());
                        }
                        if (restriction.getGroupName() == null) break;
                        viewGroups.add(restriction.getGroupName());
                        break;
                    }
                    case "Edit": {
                        if (restriction.getUsername() != null) {
                            editUsers.add(restriction.getUsername());
                        }
                        if (restriction.getGroupName() == null) break;
                        editGroups.add(restriction.getGroupName());
                        break;
                    }
                }
            }
            csvFileContent.addRow(Arrays.asList(contentId.toString(), spaceKey, titleKey, stateName, String.join((CharSequence)", ", editGroups), String.join((CharSequence)", ", editUsers), String.join((CharSequence)", ", viewGroups), String.join((CharSequence)", ", viewUsers), String.valueOf(inheritedRestrictions)));
        }))));
        return csvFileContent;
    }

    private CsvFileContent generateCSVFile(List<ContentRestrictionWorkflowRecord> records) {
        CsvFileContent csvFile = this.generateCSVHeaders();
        csvFile = this.generateCSVContent(csvFile, records);
        return csvFile;
    }
}

