/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;
requirejs(['cw', 'jquery'], function (CW, $) {

    /**
     * Just search in the DOM for the right panel present in Confluence Dashboard, call to DocumentActionsDashboard view action
     * and prepend the rendered velocity template in the right panel.
     */
    CW.toInit(function () {
        if ($(".awpdashboard").length == 1) {
            return;
        }
        var rightPanel = $("table.dashboard td.right div.padded:first");
        if (rightPanel.length == 0) {
            rightPanel = jQuery(".dashboard-group.right div:first");
            if (rightPanel.length == 0) {
                rightPanel = jQuery("div.welcome-message");  // Confluence 5.9+ Dashboard
                if (rightPanel.length == 0) {
                    return;
                }
            }
        }

        try {
            var uri = "" + ($("#confluence-context-path").attr("content") || "")
                + "/users/documentactions/dashboard/view.action";
            $.get(uri, {},
                function (response) {
                    if (response != undefined) {
                        rightPanel.prepend(response);

                        // we would like this iframe definition would be in a specific web-resource defined in atlassian-descriptor file and therefore the action vm template could include it
                        // BUT the vm template uses decorator 'none' to be rendered without headers/footers and no decorators means no web-resource processing while rendering vm template
                        // so, we do this iframe logic here, after adding rendered template to the DOM
                        // Document Actions User Dashboard
                        var DocumentActionsDashboardIframe = new CW.iframe({
                            id: 'DocumentActionsDashboardIframe',
                            url: '/documentactions/components/Dashboard',
                            width: '100%',
                            height: '100%'
                        });
                        $('#cw-documentactions-user-dashboard').html(DocumentActionsDashboardIframe.render());
                    } else {
                        console.log("Document Actions Dashboard Action returned nothing");
                    }
                });
        } catch (e) {
            console.error("ERROR!!", e);
        }
    })
});