/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.supportconsole.commands;

import com.comalatech.confluence.workflow.supportconsole.commands.AbstractSupportGeneratorCommandImplementation;
import com.comalatech.confluence.workflow.supportconsole.infrastructure.contract.SupportPresenter;
import com.comalatech.confluence.workflow.supportconsole.model.WorkflowsDataList;
import com.comalatech.confluence.workflow.supportconsole.model.contract.SupportData;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowsMarkup
extends AbstractSupportGeneratorCommandImplementation {
    private static final Logger log = LoggerFactory.getLogger(WorkflowsMarkup.class);
    private static final String TEMPLATE_PATH = "templates/supportconsole/workflowsMarkup.vm";

    public WorkflowsMarkup(SupportPresenter templateFileLayoutHelper) {
        super(templateFileLayoutHelper);
    }

    @Override
    public void generateSupportFile(SupportData data, Path baseFolder) {
        if (data instanceof WorkflowsDataList) {
            try {
                Path active = Paths.get(baseFolder.toString(), "space_workflows/active");
                Files.createDirectories(active, new FileAttribute[0]);
                Path disable = Paths.get(baseFolder.toString(), "space_workflows/disable");
                Files.createDirectories(disable, new FileAttribute[0]);
                for (WorkflowsDataList.WorkflowsData currentMarkup : ((WorkflowsDataList)data).getWorkflowsDataList()) {
                    Path filePath = currentMarkup.isActive() ? Paths.get(active.toString(), currentMarkup.getWorkflowName() + ".txt") : Paths.get(disable.toString(), currentMarkup.getWorkflowName() + ".txt");
                    this.basicWriteFile(currentMarkup, filePath, TEMPLATE_PATH);
                }
            }
            catch (Exception e) {
                log.warn("Cannot generate support file for Active/Disabled workflows", (Throwable)e);
            }
        }
    }
}

