/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.resources;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsLiteAppRequired;
import com.comalatech.confluence.ipc.api.DefaultWorkflowTemplateManager;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.DefaultWorkflowService;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import com.comalatech.confluence.workflow.rest.model.RestRemoteWorkflowsRepository;
import com.comalatech.confluence.workflow.restv2.accessor.MarkupValidationException;
import com.comalatech.confluence.workflow.restv2.accessor.WorkflowMarkupManager;
import com.comalatech.confluence.workflow.restv2.model.RestWorkflow;
import com.comalatech.confluence.workflow.restv2.model.mappers.MapperException;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mappers;
import com.comalatech.confluence.workflow.restv2.resources.AbstractRestResource;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.workflow.template.WorkflowTemplateManager;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Qualifier;

@WorkflowsAppRequired
@Path(value="/space")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@PermissionRequired(value={"ADMINISTER"})
public class WorkflowSpaceAdminResource
extends AbstractRestResource {
    private final WorkflowService workflowService;
    private final WorkflowTemplateManager workflowTemplateManager;
    private final WorkflowContainerManager workflowContainerManager;

    public WorkflowSpaceAdminResource(PermissionManager permissionManager, SpaceManager spaceManager, PageManager pageManager, WorkflowMarkupManager workflowMarkupManager, WorkflowsFeatureManager workflowsFeatureManager, WorkflowService workflowService, @Qualifier(value="workflowTemplateManager") WorkflowTemplateManager workflowTemplateManager, WorkflowContainerManager workflowContainerManager) {
        super(permissionManager, spaceManager, pageManager, workflowMarkupManager, workflowsFeatureManager);
        this.workflowService = workflowService;
        this.workflowTemplateManager = workflowTemplateManager;
        this.workflowContainerManager = workflowContainerManager;
    }

    @GET
    @Path(value="/{spaceKey}")
    public Response getWorkflows(final @PathParam(value="spaceKey") String spaceKey) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                List<com.comalatech.workflow.model.Workflow> spaceWorkflows = WorkflowSpaceAdminResource.this.workflowService.getWorkflows(spaceKey);
                if (spaceWorkflows == null) {
                    return Response.ok((Object)Collections.EMPTY_LIST).build();
                }
                try {
                    return Response.ok().entity(spaceWorkflows.stream().map(WorkflowSpaceAdminResource.this::toRest).collect(Collectors.toList())).build();
                }
                catch (MapperException ex) {
                    return WorkflowSpaceAdminResource.this.handleException(ex);
                }
            }
        }.execute();
    }

    @WorkflowsLiteAppRequired
    @GET
    @Path(value="/{spaceKey}/available")
    public Response getAvailableWorkflows(final @PathParam(value="spaceKey") String spaceKey) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                List<com.comalatech.workflow.model.Workflow> spaceWorkflows = WorkflowSpaceAdminResource.this.workflowService.getAvailableWorkflowsTemplates(spaceKey);
                if (spaceWorkflows == null) {
                    return Response.ok((Object)Collections.EMPTY_LIST).build();
                }
                try {
                    return Response.ok().entity(spaceWorkflows.stream().peek(workflow -> WorkflowSpaceAdminResource.this.moveReadAckMacroOutsideState((com.comalatech.workflow.model.Workflow)workflow)).map(WorkflowSpaceAdminResource.this::toAbstractRest).collect(Collectors.toList())).build();
                }
                catch (MapperException ex) {
                    return WorkflowSpaceAdminResource.this.handleException(ex);
                }
            }
        }.execute();
    }

    @WorkflowsLiteAppRequired
    @GET
    @Path(value="/{spaceKey}/{workflowId}")
    public Response getWorkflow(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="workflowId") String workflowId) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                List<com.comalatech.workflow.model.Workflow> spaceWorkflows = WorkflowSpaceAdminResource.this.workflowService.getWorkflows(spaceKey);
                if (spaceWorkflows == null) {
                    return Response.noContent().build();
                }
                return WorkflowSpaceAdminResource.this.getSingleWorkflowResponse(spaceWorkflows, workflowId);
            }
        }.execute();
    }

    @GET
    @Path(value="/{spaceKey}/pagetemplates")
    public Response getPageWorkflowTemplates(final @PathParam(value="spaceKey") String spaceKey) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                List<com.comalatech.workflow.model.Workflow> pageWorkflows = WorkflowSpaceAdminResource.this.workflowService.getPageWorkflowTemplates(spaceKey);
                if (pageWorkflows == null) {
                    return Response.ok((Object)Collections.EMPTY_LIST).build();
                }
                try {
                    return Response.ok().entity(pageWorkflows.stream().map(WorkflowSpaceAdminResource.this::toRest).collect(Collectors.toList())).build();
                }
                catch (MapperException ex) {
                    return WorkflowSpaceAdminResource.this.handleException(ex);
                }
            }
        }.execute();
    }

    @POST
    @Path(value="/{spaceKey}/{workflowId}/activate")
    public Response activateWorkflow(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="workflowId") String workflowId, @QueryParam(value="label") String label) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() throws WorkflowException {
                WorkflowSpaceAdminResource.this.workflowService.activateWorkflow(spaceKey, workflowId);
                return WorkflowSpaceAdminResource.this.getWorkflow(spaceKey, workflowId);
            }
        }.execute();
    }

    @POST
    @Path(value="/{spaceKey}/{workflowId}/deactivate")
    public Response deactivateWorkflow(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="workflowId") String workflowId) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                WorkflowSpaceAdminResource.this.workflowService.deactivateWorkflow(spaceKey, workflowId);
                return WorkflowSpaceAdminResource.this.getWorkflow(spaceKey, workflowId);
            }
        }.execute();
    }

    @POST
    @Path(value="/{spaceKey}/{workflowId}/hide")
    public Response hideWorkflow(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="workflowId") String workflowId) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                WorkflowSpaceAdminResource.this.workflowService.hideWorkflowTemplate(spaceKey, workflowId);
                return WorkflowSpaceAdminResource.this.getWorkflow(spaceKey, workflowId);
            }
        }.execute();
    }

    @POST
    @Path(value="/{spaceKey}/{workflowId}/show")
    public Response showWorkflow(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="workflowId") String workflowId) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                WorkflowSpaceAdminResource.this.workflowService.showWorkflowTemplate(spaceKey, workflowId);
                return WorkflowSpaceAdminResource.this.getWorkflow(spaceKey, workflowId);
            }
        }.execute();
    }

    @POST
    @Path(value="/{spaceKey}/{workflowId}/copy")
    public Response copyWorkflow(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="workflowId") String workflowId, final @QueryParam(value="active") boolean active) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() throws com.comalatech.workflow.WorkflowException {
                WorkflowSpaceAdminResource.this.workflowService.copyWorkflowToSpace(spaceKey, workflowId, active);
                return WorkflowSpaceAdminResource.this.getWorkflow(spaceKey, workflowId);
            }
        }.execute();
    }

    @WorkflowsLiteAppRequired
    @PUT
    @Path(value="/{spaceKey}/{workflowId}")
    public Response updateWorkflow(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="workflowId") String workflowId, final RestWorkflow jsonMarkup) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() throws com.comalatech.workflow.WorkflowException, MarkupValidationException {
                WorkflowSpaceAdminResource.this.workflowMarkupManager.validateJsonMarkup(jsonMarkup);
                Workflow workflow = Mappers.workflowMapper.fromRest(jsonMarkup);
                String markup = workflow.toMacro().toString();
                com.comalatech.workflow.model.Workflow updatedWorkflow = WorkflowSpaceAdminResource.this.workflowService.updateWorkflow(spaceKey, workflowId, workflow.getName(), workflow.getDescription(), null, markup, true, true, false);
                return Response.ok((Object)Mappers.workflowMapper.toRest((Workflow)updatedWorkflow)).build();
            }
        }.execute();
    }

    @PUT
    @Path(value="/{spaceKey}/restore-backup/{workflowId}")
    public Response restoreWorkflowBackup(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="workflowId") String workflowId) {
        return new AbstractRestResource.RestCommand(){

            @Override
            public Response doExecute() throws com.comalatech.workflow.WorkflowException {
                Workflow updatedWorkflow = (Workflow)WorkflowSpaceAdminResource.this.workflowService.restoreWorkflowBackup(spaceKey, workflowId);
                return Response.ok((Object)Mappers.workflowMapper.toRest(updatedWorkflow)).build();
            }
        }.execute();
    }

    @POST
    @Path(value="/{spaceKey}/")
    public Response addSpaceWorkflow(final @PathParam(value="spaceKey") String spaceKey, final RestWorkflow jsonMarkup) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() throws com.comalatech.workflow.WorkflowException, MarkupValidationException {
                WorkflowSpaceAdminResource.this.workflowMarkupManager.validateJsonMarkup(jsonMarkup);
                Workflow workflow = Mappers.workflowMapper.fromRest(jsonMarkup);
                String markup = workflow.toMacro().toString();
                com.comalatech.workflow.model.Workflow createdWorkflow = WorkflowSpaceAdminResource.this.workflowService.addSpaceWorkflow(spaceKey, markup);
                return Response.ok((Object)Mappers.workflowMapper.toRest((Workflow)createdWorkflow)).build();
            }
        }.execute();
    }

    @GET
    @Path(value="/{spaceKey}/pagetemplate/{workflowId}")
    public Response getPageTemplate(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="workflowId") String workflowId) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                try {
                    com.comalatech.workflow.model.Workflow workflow = WorkflowSpaceAdminResource.this.workflowService.getWorkflow(spaceKey, workflowId);
                    if (workflow != null) {
                        return Response.ok((Object)Mappers.workflowMapper.toRest((Workflow)workflow)).build();
                    }
                    return Response.noContent().build();
                }
                catch (WorkflowException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
                }
            }
        }.execute();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{spaceKey}/pagetemplate")
    public Response savePageTemplate(final @PathParam(value="spaceKey") String spaceKey, final RestWorkflow jsonMarkup) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() throws MarkupValidationException {
                WorkflowSpaceAdminResource.this.workflowMarkupManager.validateJsonMarkup(jsonMarkup);
                Workflow workflow = Mappers.workflowMapper.fromRest(jsonMarkup);
                try {
                    ((DefaultWorkflowTemplateManager)WorkflowSpaceAdminResource.this.workflowTemplateManager).addWorkflowTemplate(WorkflowSpaceAdminResource.this.spaceManager.getSpace(spaceKey), workflow);
                }
                catch (com.comalatech.workflow.WorkflowException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
                }
                workflow.setKey(DefaultWorkflowService.createHandle(Workflow.WorkflowType.SPACE_TEMPLATE, workflow));
                return Response.ok((Object)Mappers.workflowMapper.toRest(workflow)).build();
            }
        }.execute();
    }

    @DELETE
    @Path(value="/{spaceKey}/{workflowId}")
    public Response deleteWorkflow(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="workflowId") String workflowId) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                WorkflowSpaceAdminResource.this.workflowService.deleteWorkflow(spaceKey, workflowId);
                return Response.noContent().build();
            }
        }.execute();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{spaceKey}/workflows/repo")
    public Response loadRepositoryWorkflows(final @PathParam(value="spaceKey") String spaceKey, final @QueryParam(value="categoryId") String categoryId, final @QueryParam(value="refresh") String refresh) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                boolean reload = Boolean.parseBoolean(refresh);
                RestRemoteWorkflowsRepository restRemoteWorkflowsRepository = WorkflowSpaceAdminResource.this.workflowContainerManager.getRestRemoteWorkflows(reload, categoryId, spaceKey);
                return Response.ok().entity((Object)restRemoteWorkflowsRepository).type("application/json").build();
            }
        }.execute();
    }
}

