/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;

public class IsChildOfCondition
extends Condition {
    private String parentName;

    public IsChildOfCondition(boolean not, String parentName) {
        super(not);
        this.parentName = parentName;
    }

    @Override
    protected boolean evaluateBinary(ValueStore valueStore) throws WorkflowException {
        AbstractPage page = valueStore.getPage();
        if (page instanceof BlogPost) {
            return false;
        }
        String ancestorName = valueStore.getValue(this.parentName);
        return this.isChildOf(((Page)page).getParent(), ancestorName);
    }

    private boolean isChildOf(Page page, String pageName) {
        if (page == null) {
            return false;
        }
        if (page.getTitle().equals(pageName)) {
            return true;
        }
        return this.isChildOf(page.getParent(), pageName);
    }

    public String getParentName() {
        return this.parentName;
    }

    @Override
    public void addMacroParameters(SerializableMacro macro) {
        macro.addParameter("ischildof", (Object)((this.not ? "!" : "") + this.parentName));
    }

    @Override
    public String toString(ValueStore valueStore) {
        if (!this.not) {
            return "page is child of _" + this.parentName + "_";
        }
        return "is not child of _" + this.parentName + "_";
    }
}

