/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.listeners;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.event.events.plugin.PluginEvent;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.event.PluginEventListener;
import com.comalatech.confluence.util.WorkflowsListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginInstalledListener
extends WorkflowsListener {
    private static final Logger log = LoggerFactory.getLogger(PluginInstalledListener.class);
    private PluginAccessor pluginAccessor;
    private PluginController pluginController;
    private BandanaManager bandanaManager;
    private static final String METADATA_LISTENER_MODULE_KEY = "org.andya.confluence.plugins.metadata:metadataPageUpdateListener";
    private ThreadLocal threadLocal = new ThreadLocal();

    public PluginInstalledListener(PluginAccessor pluginAccessor, PluginController pluginController, EventPublisher eventPublisher, BandanaManager bandanaManager) {
        super(eventPublisher);
        this.pluginAccessor = pluginAccessor;
        this.pluginController = pluginController;
        this.bandanaManager = bandanaManager;
        this.checkMetadataPluginListener();
    }

    @PluginEventListener
    public void handleEvent(PluginEvent event) {
        this.checkMetadataPluginListener();
        this.setMetadataListenerDisabledBandannaFlag();
    }

    private void setMetadataListenerDisabledBandannaFlag() {
        if (log.isDebugEnabled()) {
            log.debug("setting metadata listener bandana flag to false");
        }
        this.bandanaManager.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "org.andya.confluence.plugins.metadata.unsafe", (Object)Boolean.FALSE);
    }

    public void checkMetadataPluginListener() {
        if (this.threadLocal.get() != null) {
            return;
        }
        if (this.pluginAccessor.isPluginModuleEnabled(METADATA_LISTENER_MODULE_KEY)) {
            try {
                log.error("Metadata plugin listener enabled. Disabling. See https://studio.plugins.atlassian.com/browse/APRV-333");
                this.threadLocal.set(true);
                this.pluginController.disablePluginModule(METADATA_LISTENER_MODULE_KEY);
            }
            catch (Exception e) {
                log.error("Could not disable Metadata plugin listener. Please disable Manually", (Throwable)e);
            }
            finally {
                this.threadLocal.remove();
            }
        }
    }
}

