/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.readack.model.ReadAck;
import com.comalatech.confluence.states.StateException;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StatesContainer;
import com.comalatech.confluence.states.model.Transition;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflow.macros.WorkflowParameters;
import com.comalatech.confluence.workflow.model.Approval;
import com.comalatech.confluence.workflow.model.Instructions;
import com.comalatech.confluence.workflow.model.Trigger;
import com.comalatech.confluence.workflow.model.TriggeringEvent;
import com.comalatech.confluence.workflow.model.WorkflowElement;
import com.comalatech.confluence.workflow.model.WorkflowPageFooter;
import com.comalatech.confluence.workflow.model.WorkflowPageHeader;
import com.comalatech.confluence.workflowcontainer.model.Macroable;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import com.comalatech.workflow.model.TasksMode;
import com.comalatech.workflow.model.Workflow;
import com.comalatech.workflow.model.WorkflowParameter;
import com.comalatech.workflow.model.WorkflowParameterType;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class Workflow
implements Comparable,
Macroable,
com.comalatech.workflow.model.Workflow {
    public static final String PROPERTIES_PREFIX = "com.comalatech.workflow.properties";
    public static final int SHOW_STATUS = 0;
    public static final int HIDE_STATUS = 1;
    public static final int READ_ONLY = 2;
    private int SEED = 17;
    private List<Label> labels;
    private boolean invertLabels;
    private Label[] stickyLabels;
    private StatesContainer statesContainer;
    private List<Approval> approvals;
    private ReadAck readAck;
    private List<Trigger> triggers;
    private String cssUrl;
    private String adminUserNames;
    private String pageHeadingTemplate;
    private String pageFooterTemplate;
    private WorkflowPageHeader workflowPagePageHeader;
    private WorkflowPageFooter workflowPagePageFooter;
    private Map<String, Map<String, String>> properties;
    private WorkflowParameters parameters;
    private boolean pageWorkflow;
    private boolean blogPostWorkflow;
    private boolean active;
    private boolean hideStates;
    private boolean displayProgressTracker;
    private boolean pageReadConfirmation;
    private long pageId;
    private String name;
    private String description;
    private Instructions createInstructions;
    private String tip;
    private TriggeringEvent[] triggeringEvents;
    private String[] approvalNames;
    private int version;
    private String key;
    private String blueprintKey;
    private boolean updateStatus;
    private String initMacro;
    private int hideStatus;
    private List<WorkflowParameter> workflowParameters;
    private boolean adhoc;
    private TasksMode tasksMode;
    private String errorMessage;
    private transient String containerSpaceKey;
    private transient String renderedDescription;
    private transient String handle;
    private transient WorkflowType type;
    private List<WorkflowElement> orderedElementList;

    public Workflow(WorkflowParameters parameters, List elements, Map<String, Map<String, String>> properties) throws WorkflowException {
        AbstractPage page;
        this.parameters = parameters;
        try {
            page = parameters.getAbstractPage();
            this.pageId = page.getId();
        }
        catch (MacroException e) {
            throw new RuntimeException();
        }
        this.setName(parameters.getName() != null ? parameters.getName() : "");
        this.description = parameters.getDescription() != null ? parameters.getDescription() : this.name;
        this.tip = parameters.getTip();
        this.version = page.getVersion();
        this.adminUserNames = parameters.getAdminUsers();
        this.hideStatus = parameters.getHidestatus();
        this.key = parameters.getKey();
        this.blueprintKey = parameters.getBlueprintKey();
        this.initMacro = parameters.getInitMacro();
        if (TextUtils.stringSet((String)this.initMacro)) {
            this.initMacro = "{" + this.initMacro + "}\n";
        }
        this.registerElements(elements);
        this.setApprovalNames();
        this.properties = properties != null ? properties : new HashMap<String, Map<String, String>>();
        this.pageWorkflow = parameters.isPageWorkflows();
        this.blogPostWorkflow = parameters.isBlogPostWorkflow();
        this.cssUrl = parameters.getWorkflowCss();
        this.pageHeadingTemplate = parameters.getPageHeaderTemplate();
        this.pageFooterTemplate = parameters.getPageFooterTemplate();
        this.setStickyLabels(parameters.getStickyLabels());
        this.setCssUrl(parameters.getWorkflowCss());
        this.active = parameters.isActive();
        this.adhoc = parameters.isAdhoc();
        this.hideStates = parameters.isHideStates();
        this.tasksMode = parameters.getTasksMode();
        this.displayProgressTracker = parameters.isDisplayProgressTracker();
        this.updateStatus = parameters.isUpdateStatus();
        this.labels = parameters.getLabels();
        this.invertLabels = parameters.isInvertLabels();
        this.setPageReadConfirmation(parameters.isPageReadConfirmation());
    }

    public int getHideStatus() {
        return this.hideStatus;
    }

    public void setHideStatus(int hideStatus) {
        this.hideStatus = hideStatus;
    }

    public static Workflow createDummyWorkflow(String stateName, List<Approval> approvals, AbstractPage page) {
        State state = new State(stateName, false);
        state.setApprovals(approvals);
        try {
            return new Workflow(new WorkflowParameters(new HashMap(), (RenderContext)page.toPageContext(), null), Collections.singletonList(state), null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Workflow() {
        this.active = true;
        this.pageWorkflow = true;
        this.blogPostWorkflow = true;
        this.pageId = 0L;
        this.version = 0;
        this.setName("New Workflow");
        this.statesContainer = new StatesContainer();
        this.approvals = new ArrayList<Approval>();
        this.properties = new HashMap<String, Map<String, String>>();
        this.triggers = new ArrayList<Trigger>();
        this.triggeringEvents = new TriggeringEvent[0];
        this.orderedElementList = new ArrayList<WorkflowElement>();
        this.workflowParameters = new ArrayList<WorkflowParameter>();
        this.tasksMode = TasksMode.DEFAULT;
        this.labels = new ArrayList<Label>();
    }

    private void setApprovalNames() {
        this.approvalNames = new String[this.approvals.size()];
        int i = 0;
        Iterator<Approval> iterator = this.approvals.iterator();
        while (iterator.hasNext()) {
            Approval approval1;
            Approval approval = approval1 = iterator.next();
            this.approvalNames[i++] = approval.getName();
        }
        Arrays.sort(this.approvalNames);
    }

    public void registerElements(List elements) throws WorkflowException {
        this.workflowParameters = new ArrayList<WorkflowParameter>();
        this.triggeringEvents = new TriggeringEvent[0];
        this.approvals = new ArrayList<Approval>();
        this.triggers = new ArrayList<Trigger>();
        this.statesContainer = new StatesContainer();
        this.orderedElementList = new ArrayList<WorkflowElement>();
        for (Object element1 : elements) {
            WorkflowElement element = (WorkflowElement)element1;
            if (element instanceof Trigger) {
                this.registerTrigger((Trigger)element);
            } else if (element instanceof Approval) {
                this.registerApproval((Approval)element);
            } else if (element instanceof Workflow.State) {
                this.registerState((State)element);
            } else if (element instanceof WorkflowParameter) {
                this.workflowParameters.add((WorkflowParameter)((Object)element));
            } else if (element instanceof WorkflowPageFooter) {
                this.setWorkflowPagePageFooter((WorkflowPageFooter)element);
            } else if (element instanceof WorkflowPageHeader) {
                this.setWorkflowPagePageHeader((WorkflowPageHeader)element);
            } else if (element instanceof ReadAck) {
                if (this.readAck != null) continue;
                this.setReadAck((ReadAck)element);
            }
            this.orderedElementList.add(element);
        }
    }

    public void addState(State oldState, State newState) throws StateException {
        int ix = this.orderedElementList.indexOf(oldState);
        if (ix < 0 || ix == this.orderedElementList.size() - 1) {
            this.orderedElementList.add(newState);
        } else {
            this.orderedElementList.add(ix + 1, newState);
        }
        this.statesContainer.addState(oldState, newState);
    }

    public void removeState(String name) {
        State removedState = this.statesContainer.getState(name);
        if (removedState == null) {
            return;
        }
        ListIterator<WorkflowElement> iterator = this.orderedElementList.listIterator();
        while (iterator.hasNext()) {
            WorkflowElement state = iterator.next();
            if (!state.equals(removedState)) continue;
            iterator.remove();
        }
        this.statesContainer.removeState(name);
    }

    public List<Trigger> getExplicitTriggers() {
        ArrayList<Trigger> explicitTriggers = new ArrayList<Trigger>();
        for (Trigger trigger : this.triggers) {
            if (!trigger.isExplicit()) continue;
            explicitTriggers.add(trigger);
        }
        return explicitTriggers;
    }

    public void registerState(State state) throws WorkflowException {
        for (Approval approval : state.getApprovals()) {
            approval.setAdminUserNames(this.adminUserNames);
        }
        this.statesContainer.addState(null, state);
    }

    public void registerStateTransitions() {
        if (this.statesContainer == null) {
            return;
        }
        for (State state : this.statesContainer.getStates()) {
            for (Transition transition : state.getTransitions()) {
                this.registerTrigger(transition);
            }
        }
    }

    private void registerTrigger(Trigger trigger) {
        this.triggers.add(trigger);
        for (Class event : trigger.getTriggeringEvents()) {
            this.registerTrigger(trigger, event);
        }
    }

    private void registerTrigger(Trigger trigger, Class event) {
        TriggeringEvent triggeringEvent;
        int ix = Arrays.binarySearch(this.triggeringEvents, event);
        if (ix >= 0) {
            triggeringEvent = this.triggeringEvents[ix];
        } else {
            triggeringEvent = new TriggeringEvent(event);
            TriggeringEvent[] newevents = new TriggeringEvent[this.triggeringEvents.length + 1];
            System.arraycopy(this.triggeringEvents, 0, newevents, 0, this.triggeringEvents.length);
            newevents[this.triggeringEvents.length] = triggeringEvent;
            this.triggeringEvents = newevents;
            Arrays.sort(this.triggeringEvents);
        }
        triggeringEvent.addTrigger(trigger);
    }

    public void validateWorkflow() throws WorkflowException {
        this.validateWorkflowParametersDuration();
        this.validateWorkflowReadAckMacro();
    }

    private void validateWorkflowParametersDuration() throws WorkflowException {
        for (WorkflowParameter param : this.workflowParameters) {
            if (param.getType() != WorkflowParameterType.DURATION) continue;
            try {
                TimerUtils.parsePeriod(param.getValue());
            }
            catch (Exception e) {
                throw new WorkflowUserException("comalatech.awp.parameters.parameters.error.duration", (Object)new Object[]{param.getName(), param.getValue()}, true);
            }
        }
    }

    private void validateWorkflowReadAckMacro() throws WorkflowException {
        this.validateSingleReadAckMacroCheckingFinalStates();
        this.validateReadAckMacroWithoutFinalState();
        this.moveReadAckMacroOutOfState();
    }

    public void moveReadAckMacroOutOfState() {
        State finalState = this.statesContainer.getFinalState();
        if (finalState != null && finalState.getReadAck() != null) {
            this.readAck = finalState.getReadAck();
            finalState.setReadAck(null);
            this.orderedElementList.add(this.readAck);
        }
    }

    private void validateSingleReadAckMacroCheckingFinalStates() throws WorkflowException {
        State finalState = this.statesContainer.getFinalState();
        if (finalState != null && finalState.getReadAck() != null && this.readAck != null) {
            throw new WorkflowUserException("readack.markup.error.duplicatedMacro.stateAndOutside", true);
        }
    }

    private void validateReadAckMacroWithoutFinalState() throws WorkflowException {
        List<State> definedStates = this.statesContainer.getStates();
        State finalState = this.statesContainer.getFinalState();
        if (definedStates.size() > 0 && finalState == null && this.readAck != null) {
            throw new WorkflowUserException("readack.markup.error.missingFinalState", true);
        }
    }

    public void registerApproval(Approval approval) {
        approval.setAdminUserNames(this.adminUserNames);
        this.approvals.add(approval);
    }

    public List<Approval> getApprovals(AbstractPage page) {
        if (page == null) {
            return this.approvals;
        }
        ArrayList<Approval> pageApprovals = new ArrayList<Approval>();
        for (Approval approval : this.approvals) {
            if (!approval.isVisible(page)) continue;
            pageApprovals.add(approval);
        }
        return pageApprovals;
    }

    public String[] getSortedApprovalNames() {
        return this.approvalNames;
    }

    public Trigger[] getTriggers(ConfluenceEvent event) {
        int ix = Arrays.binarySearch(this.triggeringEvents, event);
        if (ix < 0) {
            return new Trigger[0];
        }
        return this.triggeringEvents[ix].getTriggers(event);
    }

    public boolean isLabelSticky(Label label) {
        return this.stickyLabels != null && Arrays.binarySearch(this.stickyLabels, label) >= 0;
    }

    public List<Label> getStickyLabels() {
        return this.stickyLabels != null ? Arrays.asList(this.stickyLabels) : null;
    }

    public void setStickyLabels(List<Label> stickyLabels) {
        this.stickyLabels = stickyLabels.toArray(new Label[stickyLabels.size()]);
    }

    public void setStickyLabels(String labelsList) throws WorkflowException {
        if (!TextUtils.stringSet((String)labelsList)) {
            return;
        }
        String[] labelNames = labelsList.split(",");
        ArrayList<Label> labels = new ArrayList<Label>(labelNames.length);
        for (int i = 0; i < labelNames.length; ++i) {
            ParsedLabelName label = LabelParser.parse((String)labelNames[i].trim());
            if (label == null) {
                throw new WorkflowException("invalid label " + labelNames[i]);
            }
            labels.add(label.toLabel());
        }
        Collections.sort(labels);
        this.stickyLabels = labels.toArray(new Label[labels.size()]);
    }

    public boolean hasTriggers() {
        return this.triggeringEvents.length > 0;
    }

    public String getCssUrl() {
        return this.cssUrl;
    }

    public void setCssUrl(String cssUrl) {
        this.cssUrl = cssUrl;
    }

    @Deprecated
    public Label getLabel() {
        if (this.labels != null && this.labels.size() > 0) {
            return this.labels.get(0);
        }
        return null;
    }

    @Override
    @Deprecated
    public String getLabelName() {
        if (this.getLabel() != null) {
            return this.getLabel().getName();
        }
        return null;
    }

    @Override
    public List<String> getLabelNames() {
        ArrayList<String> labelNames = new ArrayList<String>();
        if (this.labels != null) {
            for (Label label : this.labels) {
                labelNames.add(label.getName());
            }
        }
        return labelNames;
    }

    public boolean isActiveForLabels(List<Label> testLabels) {
        if (this.labels == null || this.labels.isEmpty()) {
            return true;
        }
        if (testLabels != null) {
            for (Label testLabel : testLabels) {
                for (Label label : this.labels) {
                    if (!label.equals((Object)testLabel)) continue;
                    return !this.invertLabels;
                }
            }
        }
        return this.invertLabels;
    }

    public boolean isActiveForLabel(String testLabel) {
        ArrayList<Label> labelsList = new ArrayList<Label>();
        if (TextUtils.stringSet((String)testLabel) && LabelParser.parse((String)testLabel) != null) {
            labelsList.add(LabelParser.parse((String)testLabel).toLabel());
        }
        return this.isActiveForLabels(labelsList);
    }

    @Override
    public String getWorkflowMarkup() {
        return this.toMacro().toString();
    }

    @Override
    public List<String> getStateNames() {
        ArrayList<String> stateNames = new ArrayList<String>();
        for (Workflow.State state : this.statesContainer.getStates()) {
            stateNames.add(state.getName());
        }
        return stateNames;
    }

    public Map<String, Map<String, String>> getProperties() {
        return this.properties;
    }

    public Map<String, String> getProperties(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(Workflow.makePropertiesKey(key));
    }

    public List<WorkflowElement> getOrderedElementList() {
        return this.orderedElementList;
    }

    public static String makePropertiesKey(String propertiesKey) {
        return "com.comalatech.workflow.properties." + propertiesKey;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Instructions getCreateInstructions() {
        return this.createInstructions;
    }

    public void setCreateInstructions(Instructions createInstructions) {
        this.createInstructions = createInstructions;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Page getPage(PageManager pageManager) {
        return pageManager.getPage(this.pageId);
    }

    public StatesContainer getStatesContainer() {
        return this.statesContainer;
    }

    public ReadAck getReadAck() {
        return this.readAck;
    }

    private void setReadAck(ReadAck readAck) {
        this.readAck = readAck;
    }

    @Override
    public List<Workflow.State> getWorkflowStates() {
        ArrayList<Workflow.State> stateList = new ArrayList<Workflow.State>();
        stateList.addAll(this.statesContainer.getStates());
        return stateList;
    }

    public int getVersion() {
        return this.version;
    }

    public String getInitMacro() {
        return this.initMacro;
    }

    public void setInitMacro(String initMacro) {
        this.initMacro = initMacro;
    }

    public int hashCode() {
        if (this.pageId > 0L) {
            return (this.SEED * 37 + (int)(this.pageId ^ this.pageId >>> 32)) * 37 + this.version;
        }
        return this.name.hashCode();
    }

    public String getWorkflowHash() {
        return Integer.toHexString(this.name.hashCode());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name != null ? name.trim() : null;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public long getPageId() {
        return this.pageId;
    }

    public List<Approval> getApprovals() {
        if (this.approvals.size() > 0) {
            throw new RuntimeException("Oops! Deprecated workflow");
        }
        return this.approvals;
    }

    public String getAdminUserNames() {
        return this.adminUserNames;
    }

    public void setAdminUserNames(String adminUserNames) {
        this.adminUserNames = adminUserNames;
    }

    public String getPageHeaderTemplate() {
        return this.pageHeadingTemplate;
    }

    public String getPageFooterTemplate() {
        return this.pageFooterTemplate;
    }

    public boolean isActiveForAbstractPage(AbstractPage page) {
        if (page instanceof Page) {
            return this.pageWorkflow;
        }
        return this.blogPostWorkflow;
    }

    public boolean isPageWorkflow() {
        return this.pageWorkflow;
    }

    public void setPageWorkflow(boolean pageWorkflow) {
        this.pageWorkflow = pageWorkflow;
    }

    public boolean isBlogPostWorkflow() {
        return this.blogPostWorkflow;
    }

    public void setBlogPostWorkflow(boolean blogPostWorkflow) {
        this.blogPostWorkflow = blogPostWorkflow;
    }

    public boolean isAdhoc() {
        return this.adhoc;
    }

    public void setAdhoc(boolean adhoc) {
        this.adhoc = adhoc;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        Workflow w = (Workflow)o;
        if (this.pageId < w.pageId) {
            return -1;
        }
        if (this.pageId == w.pageId) {
            return 0;
        }
        return 1;
    }

    protected String labelListToString(List<Label> labels) {
        StringBuilder labelString = new StringBuilder();
        if (labels != null) {
            for (Label label : labels) {
                if (labelString.length() > 0) {
                    labelString.append(", ");
                }
                labelString.append(label.getName());
            }
        }
        return labelString.toString();
    }

    @Override
    public SerializableMacro toMacro() {
        SerializableMacro macro = new SerializableMacro("workflow");
        macro.addParameter("name", (Object)this.name);
        macro.addParameter("key", (Object)this.key);
        macro.addParameter("blueprintkey", (Object)this.blueprintKey);
        macro.addParameter(WorkflowParameters.PARAM_WORKFLOW_LABEL[0], (Object)this.labelListToString(this.labels));
        if (this.invertLabels) {
            macro.addParameter("invertlabel", (Object)true);
        }
        macro.addParameter("css", (Object)this.cssUrl);
        macro.addParameter("adminusers", (Object)this.adminUserNames);
        if (this.stickyLabels != null && this.stickyLabels.length > 0) {
            StringBuffer sb = new StringBuffer();
            String separator = "";
            for (Label stickyLabel : this.stickyLabels) {
                sb.append(separator).append(stickyLabel);
                separator = ",";
            }
            macro.addParameter("stickylabels", (Object)sb.toString());
        }
        macro.addParameter("header", (Object)this.pageHeadingTemplate);
        macro.addParameter("footer", (Object)this.pageFooterTemplate);
        if (!this.pageWorkflow || !this.blogPostWorkflow) {
            macro.addParameter("content", (Object)(this.pageWorkflow ? "pages" : (this.blogPostWorkflow ? "news" : null)));
        }
        if (this.updateStatus) {
            macro.addParameter("updatestatus", (Object)true);
        }
        if (!this.active) {
            macro.addParameter("disabled", (Object)true);
        }
        if (this.adhoc) {
            macro.addParameter("adhoc", (Object)true);
        }
        if (this.hideStatus > 0) {
            macro.addParameter("hidestatus", (Object)(this.hideStatus == 1 ? "true" : "readonly"));
        }
        if (this.hideStates) {
            macro.addParameter("hideStates", (Object)true);
        }
        if (TextUtils.stringSet((String)this.tip)) {
            macro.addParameter("tip", (Object)this.tip.replaceAll("\\|", "!"));
        }
        if (this.tasksMode != TasksMode.DEFAULT) {
            macro.addParameter("stricttasks", (Object)(this.tasksMode == TasksMode.STRICT ? 1 : 0));
        }
        if (!this.displayProgressTracker) {
            macro.addParameter("progresstracker", (Object)false);
        }
        if (TextUtils.stringSet((String)this.description)) {
            macro.addMacro(new SerializableMacro("description", true).setBody(this.description));
        }
        if (this.createInstructions != null) {
            macro.addMacro(new SerializableMacro("workflow-instructions", true).setBody(this.createInstructions.getBody()).addParameter("style", (Object)this.createInstructions.getStyle()).addParameter("title", (Object)this.createInstructions.getTitle()));
        }
        for (Map.Entry<String, Map<String, String>> property : this.properties.entrySet()) {
            SerializableMacro propertiesMacro = new SerializableMacro("workflowproperties");
            propertiesMacro.addParameter(property.getKey().substring(PROPERTIES_PREFIX.length() + 1));
            propertiesMacro.addParameters(property.getValue());
            macro.addMacro(propertiesMacro);
        }
        for (WorkflowElement element : this.orderedElementList) {
            if (!(element instanceof Macroable)) continue;
            macro.addMacro(((Macroable)((Object)element)).toMacro(this.hasFinalState()));
        }
        if (this.pageReadConfirmation) {
            macro.addParameter(WorkflowParameters.PARAM_PAGE_READ_CONFIRMATION, (Object)true);
        }
        return macro;
    }

    public boolean hasFinalState() {
        return this.getStatesContainer().getFinalState() != null;
    }

    public String toString() {
        return this.name;
    }

    public boolean isHideStates() {
        return this.hideStates;
    }

    public boolean isLegacy() {
        return this.approvals.size() > 0;
    }

    public List<WorkflowParameter> getWorkflowParameters() {
        return this.workflowParameters;
    }

    public void setWorkflowParameters(List<WorkflowParameter> workflowParameters) {
        this.workflowParameters = workflowParameters;
    }

    public void setHideStates(boolean hideStates) {
        this.hideStates = hideStates;
    }

    public String getContainerSpaceKey() {
        return this.containerSpaceKey;
    }

    public void setContainerSpaceKey(String containerSpaceKey) {
        this.containerSpaceKey = containerSpaceKey;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getTip() {
        return this.tip;
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    public WorkflowPageHeader getWorkflowPagePageHeader() {
        return this.workflowPagePageHeader;
    }

    private void setWorkflowPagePageHeader(WorkflowPageHeader workflowPagePageHeader) {
        this.workflowPagePageHeader = workflowPagePageHeader;
    }

    public TasksMode getTasksMode() {
        return this.tasksMode;
    }

    public void setTasksMode(TasksMode tasksMode) {
        this.tasksMode = tasksMode;
    }

    public WorkflowPageFooter getWorkflowPagePageFooter() {
        return this.workflowPagePageFooter;
    }

    private void setWorkflowPagePageFooter(WorkflowPageFooter workflowPagePageFooter) {
        this.workflowPagePageFooter = workflowPagePageFooter;
    }

    public boolean isDisplayProgressTracker() {
        return this.displayProgressTracker;
    }

    public void setDisplayProgressTracker(boolean displayProgressTracker) {
        this.displayProgressTracker = displayProgressTracker;
    }

    public String getBlueprintKey() {
        return this.blueprintKey;
    }

    public void setBlueprintKey(String blueprintKey) {
        this.blueprintKey = blueprintKey;
    }

    public String getRenderedDescription() {
        return this.renderedDescription;
    }

    public void setRenderedDescription(String renderedDescription) {
        this.renderedDescription = renderedDescription;
    }

    public boolean isUpdateStatus() {
        return this.updateStatus;
    }

    public void setUpdateStatus(boolean updateStatus) {
        this.updateStatus = updateStatus;
    }

    public WorkflowType getType() {
        return this.type;
    }

    public void setType(WorkflowType type) {
        this.type = type;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public void setLabels(List<Label> labels) {
        this.labels = labels;
    }

    @Override
    public boolean isInvertLabels() {
        return this.invertLabels;
    }

    public void setInvertLabels(boolean invertLabels) {
        this.invertLabels = invertLabels;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public WorkflowParameters getParameters() {
        return this.parameters;
    }

    public boolean isPageReadConfirmation() {
        return this.pageReadConfirmation;
    }

    public void setPageReadConfirmation(boolean pageReadConfirmation) {
        this.pageReadConfirmation = pageReadConfirmation;
    }

    public static enum WorkflowType {
        SPACE,
        LINKED_SPACE,
        SPACE_TEMPLATE,
        GLOBALE_TEMPLATE,
        PAGE;

    }
}

