/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.readack.job;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.comalatech.confluence.readack.ReadAckException;
import com.comalatech.confluence.readack.activeObjects.accessor.ReadAckRecordAccessor;
import com.comalatech.confluence.readack.model.ReadAckConfig;
import com.comalatech.confluence.readack.model.ReadAckStatusType;
import com.comalatech.confluence.readack.service.ReadAckConfigManager;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.user.WorkflowAuthenticatedUserThreadLocal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverdueReadAckJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(OverdueReadAckJob.class);
    private final TransactionTemplate transactionTemplate;
    private final ReadAckConfigManager readAckConfigManager;
    private final ReadAckRecordAccessor readAckRecordAccessor;
    private final PageManager pageManager;

    public OverdueReadAckJob(TransactionTemplate transactionTemplate, ReadAckConfigManager readAckConfigManager, ReadAckRecordAccessor readAckRecordAccessor, PageManager pageManager) {
        this.transactionTemplate = transactionTemplate;
        this.readAckConfigManager = readAckConfigManager;
        this.readAckRecordAccessor = readAckRecordAccessor;
        this.pageManager = pageManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug("OverdueReadAckJob starting");
        }
        WorkflowAuthenticatedUserThreadLocal.setInExpiryJob(true);
        try {
            PluginContainerManager.autowireComponent(this);
            List pageIds = (List)this.transactionTemplate.execute(() -> this.readAckRecordAccessor.getOverduePages());
            if (pageIds.size() > 0) {
                for (Long pageId : pageIds) {
                    if (request.isCancellationRequested()) {
                        JobRunnerResponse jobRunnerResponse = JobRunnerResponse.aborted((String)"Job cancelled.");
                        return jobRunnerResponse;
                    }
                    this.transactionTemplate.execute(() -> {
                        block6: {
                            AbstractPage page = this.pageManager.getAbstractPage(pageId.longValue());
                            if (page != null) {
                                try {
                                    ReadAckConfig readAckConfig = this.readAckConfigManager.loadReadAckConfig(page);
                                    if (readAckConfig != null) {
                                        if (readAckConfig.status.equals((Object)ReadAckStatusType.PageStatusType.PENDING)) {
                                            this.readAckConfigManager.setReadAckAsOverdue(page, readAckConfig);
                                            this.readAckConfigManager.sendNotificationOverdue(page);
                                        }
                                        break block6;
                                    }
                                    log.debug("Read Ack config for page " + pageId + " entry does not exist. Consider purging old ReadAck records.");
                                }
                                catch (ReadAckException e) {
                                    log.error(e.getMessage());
                                }
                            } else {
                                log.debug("Page " + pageId + " does not exist. Consider purging old ReadAck records");
                            }
                        }
                        return null;
                    });
                }
            }
            object = JobRunnerResponse.success((String)"Job finished successfully.");
            return object;
        }
        catch (Exception e) {
            log.error("Exception at OverdueReadAckJob", (Throwable)e);
            object = JobRunnerResponse.failed((String)"Job failed.");
            return object;
        }
        finally {
            WorkflowAuthenticatedUserThreadLocal.setInExpiryJob(false);
        }
    }
}

