/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.readack.activeObjects.entity;

import com.comalatech.confluence.readack.model.ReadAckStatusType;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.java.ao.schema.AutoIncrement;
import net.java.ao.schema.Default;
import net.java.ao.schema.NotNull;
import net.java.ao.schema.PrimaryKey;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;

public interface BaseReadAckRecord {
    public static final String PARAMETER_TYPE = "parameter";
    public static final String MANUAL_TYPE = "manual";

    @AutoIncrement
    @NotNull
    @PrimaryKey(value="ID")
    public Long getId();

    @NotNull
    public String getUserKey();

    public void setUserKey(String var1);

    @NotNull
    public Long getPageId();

    public void setPageId(Long var1);

    public Integer getPageVersion();

    public void setPageVersion(Integer var1);

    @NotNull
    public Integer getPageStateId();

    public void setPageStateId(Integer var1);

    @NotNull
    public ReadAckStatusType.UserStatusType getStatus();

    public void setStatus(ReadAckStatusType.UserStatusType var1);

    @NotNull
    public Long getCreationTimestamp();

    public void setCreationTimestamp(Long var1);

    public Long getDueDateTimestamp();

    public void setDueDateTimestamp(Long var1);

    public Long getAcknowledgedTimestamp();

    public void setAcknowledgedTimestamp(Long var1);

    public Long getClosedTimestamp();

    public void setClosedTimestamp(Long var1);

    @NotNull
    @Default(value="parameter")
    public String getAssignmentType();

    public void setAssignmentType(String var1);

    public static enum ReadAckAssignmentType {
        PARAMETER("parameter"),
        MANUAL("manual");

        private static Map<String, ReadAckAssignmentType> FORMAT_MAP;
        private final String formatted;

        private ReadAckAssignmentType(String formatted) {
            this.formatted = formatted;
        }

        @JsonValue
        public String toString() {
            return this.formatted;
        }

        @JsonCreator
        public static ReadAckAssignmentType fromString(String string) {
            return Optional.ofNullable(FORMAT_MAP.get(string)).orElseThrow(() -> new IllegalArgumentException(string));
        }

        static {
            FORMAT_MAP = Stream.of(ReadAckAssignmentType.values()).collect(Collectors.toMap(s -> s.formatted, Function.identity()));
        }
    }
}

