/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.contributors;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.contributors.ContributorsManager;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.workflow.event.StateChangeEvent;
import com.comalatech.workflow.event.TaskAssignEvent;
import com.comalatech.workflow.event.approval.ApprovalApprovedEvent;
import com.comalatech.workflow.event.approval.ApprovalAssignedEvent;
import com.comalatech.workflow.event.approval.ApprovalRejectedEvent;
import com.comalatech.workflow.model.Assignment;
import com.opensymphony.util.TextUtils;

public class ContributorsListener
extends WorkflowsListener {
    private final ContributorsManager contributorsManager;
    private final WorkflowAccessor workflowAccessor;

    public ContributorsListener(EventPublisher eventPublisher, ContributorsManager contributorsManager, WorkflowAccessor workflowAccessor) {
        super(eventPublisher);
        this.contributorsManager = contributorsManager;
        this.workflowAccessor = workflowAccessor;
    }

    @EventListener
    public void approvalApprovedEvent(ApprovalApprovedEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updatePage(content, AuthenticatedUserThreadLocal.getUsername());
    }

    @EventListener
    public void approvalRejectedEvent(ApprovalRejectedEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updatePage(content, AuthenticatedUserThreadLocal.getUsername());
    }

    @EventListener
    public void approvalAssignedEvent(ApprovalAssignedEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updatePageAssignment(content, event.getAssignment());
    }

    @EventListener
    public void stateChangeEvent(StateChangeEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updatePage(content, AuthenticatedUserThreadLocal.getUsername());
    }

    @EventListener
    public void taskAssignedEvent(TaskAssignEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updatePageAssignment(content, event.getAssignment());
    }

    @EventListener
    public void pageUpdateEvent(PageUpdateEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        if (this.workflowAccessor.hasWorkflowsOrApprovals((ContentEntityObject)content) || this.workflowAccessor.hasWorkflows(content.getSpace())) {
            this.updatePage(content, AuthenticatedUserThreadLocal.getUsername());
        }
    }

    @EventListener
    public void blogpostUpdateEvent(BlogPostUpdateEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        if (this.workflowAccessor.hasWorkflowsOrApprovals((ContentEntityObject)content) || this.workflowAccessor.hasWorkflows(content.getSpace())) {
            this.updatePage(content, AuthenticatedUserThreadLocal.getUsername());
        }
    }

    private void updatePage(AbstractPage page, String userName) {
        this.contributorsManager.addContributor(page, userName);
    }

    private void updatePageAssignment(AbstractPage page, Assignment assignment) {
        this.contributorsManager.addContributor(page, assignment.getPerformer());
        if (TextUtils.stringSet((String)assignment.getAssignee())) {
            this.contributorsManager.addContributor(page, assignment.getAssignee());
        }
    }
}

