/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var AWP = AWP || {};
AWP.Collection = AWP.Collection || {};
AWP.Collection.Users = Backbone.Collection.extend({
    model: AWP.Model.User,

    /**
     * Returns a comma separated list of user's names
     */
    toNamesList : function() {
        var users = "";
        var first = true;
        _.each(this.models,function(user) {
            if (! first) {
                users += ",";
            } else {
                first = false;
            }
            users += user.get("name");
        });
        return users;
    }


});