/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.facade;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.randombits.facade.FacadeAssistant;
import org.randombits.facade.FacadeException;
import org.randombits.facade.MethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacadeInvocationHandler
implements InvocationHandler {
    Object wrapped;
    private ClassLoader wrapperLoader;
    private ClassLoader wrappedLoader;

    public FacadeInvocationHandler(Object facaded) {
        this.init(facaded);
    }

    private void init(Object facaded) {
        if (this.wrapped == null) {
            this.wrapped = facaded;
            this.wrapperLoader = this.getClass().getClassLoader();
            this.wrappedLoader = facaded.getClass().getClassLoader();
        }
    }

    public Object getWrapped() {
        return this.wrapped;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        try {
            Method iMethod = this.findWrappedMethod(method);
            MethodSignature signature = new MethodSignature(iMethod);
            FacadeAssistant.FacadeInfo info = FacadeAssistant.getInstance().findFacadeInfo(this.wrapped.getClass(), signature);
            Class<?> arrayType = this.findArrayType(info, args);
            args = this.toWrapped(args, method.getParameterTypes(), info);
            Class<?> returnType = FacadeAssistant.getInstance().findClass(iMethod.getReturnType(), this.wrapperLoader);
            Object returnValue = iMethod.invoke(this.wrapped, args);
            return FacadeAssistant.getInstance().prepareObject(returnValue, returnType, this.wrapperLoader, info.isReturnFacadable(), arrayType);
        }
        catch (NoSuchMethodException e) {
            throw new FacadeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new FacadeException(e);
        }
        catch (IllegalAccessException e) {
            throw new FacadeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Exception) {
                Exception targetException = (Exception)e.getTargetException();
                Class<?> wrapperClass = FacadeAssistant.getInstance().findClass(targetException.getClass(), this.wrapperLoader);
                Exception preparedException = (Exception)FacadeAssistant.getInstance().prepareObject(targetException, wrapperClass, this.wrapperLoader, false);
                if (preparedException != null) {
                    throw preparedException;
                }
            }
            throw new FacadeException(e);
        }
    }

    private Class<?> findArrayType(FacadeAssistant.FacadeInfo info, Object[] args) {
        int arrayTypeParam = info.getArrayTypeParameter();
        if (arrayTypeParam >= 0) {
            if (args == null || arrayTypeParam >= args.length) {
                throw new FacadeException("Illegal array type parameter index: " + arrayTypeParam);
            }
            Object arg = args[arrayTypeParam];
            if (arg == null) {
                return null;
            }
            if (arg instanceof Class) {
                return (Class)arg;
            }
            Class<?> argClass = arg.getClass();
            return argClass.isArray() ? argClass.getComponentType() : argClass;
        }
        return null;
    }

    private Object[] toWrapped(Object[] objs, Class<?>[] types, FacadeAssistant.FacadeInfo info) {
        if (objs == null) {
            return null;
        }
        Object[] wrappedObjs = new Object[objs.length];
        for (int i = 0; i < types.length; ++i) {
            if (Class.class.isInstance(objs[i])) {
                wrappedObjs[i] = FacadeAssistant.getInstance().findClass((Class)objs[i], this.wrappedLoader);
                continue;
            }
            Class<?> wrappedClass = FacadeAssistant.getInstance().findClass(types[i], this.wrappedLoader);
            wrappedObjs[i] = FacadeAssistant.getInstance().prepareObject(objs[i], wrappedClass, this.wrappedLoader, info.isParameterFacadable(i));
        }
        return wrappedObjs;
    }

    private Method findWrappedMethod(Method method) throws NoSuchMethodException, ClassNotFoundException {
        Class<?>[] paramTypes = FacadeAssistant.getInstance().toFacadeClasses(method.getParameterTypes(), this.wrappedLoader, true);
        Method wrappedMethod = this.findHighestMethod(this.wrapped.getClass(), method.getName(), paramTypes);
        if (wrappedMethod == null) {
            throw new NoSuchMethodException(method.getName());
        }
        return wrappedMethod;
    }

    private Method findHighestMethod(Class<?> cls, String method, Class<?> ... paramTypes) throws SecurityException {
        Method parentMethod;
        Class<?>[] interfaces = cls.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Method ifaceMethod = this.findHighestMethod(interfaces[i], method, paramTypes);
            if (ifaceMethod == null) continue;
            return ifaceMethod;
        }
        if (cls.getSuperclass() != null && (parentMethod = this.findHighestMethod(cls.getSuperclass(), method, paramTypes)) != null) {
            return parentMethod;
        }
        try {
            return cls.getMethod(method, paramTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

