/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.support;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.randombits.confluence.support.ServletAssistant;
import org.randombits.storage.Storage;
import org.randombits.storage.servlet.RequestAttributeStorage;
import org.randombits.storage.servlet.RequestParameterStorage;
import org.randombits.storage.servlet.SessionStorage;

public class RequestInfo {
    private Storage reqParams;
    private RequestAttributeStorage reqAttrs;
    private SessionStorage sessionStorage;
    private HttpServletRequest req;
    private HttpSession session;

    public RequestInfo(HttpServletRequest req) {
        this.req = req;
    }

    public RequestInfo() {
    }

    public Storage getRequestParams() {
        if (this.reqParams == null && this.getRequest() != null) {
            this.reqParams = new RequestParameterStorage(this.getRequest());
        }
        return this.reqParams;
    }

    public Storage getRequestAttributes() {
        HttpServletRequest req;
        if (this.reqAttrs == null && (req = this.getRequest()) != null) {
            this.reqAttrs = new RequestAttributeStorage(req);
        }
        return this.reqAttrs;
    }

    public HttpServletRequest getRequest() {
        if (this.req == null) {
            this.req = ServletAssistant.getInstance().getRequest();
        }
        return this.req;
    }

    public HttpSession getSession() {
        HttpServletRequest req;
        if (this.session == null && (req = this.getRequest()) != null) {
            this.session = req.getSession();
        }
        return this.session;
    }

    public Storage getSessionAttributes() {
        HttpSession session;
        if (this.sessionStorage == null && (session = this.getSession()) != null) {
            this.sessionStorage = new SessionStorage(session);
        }
        return this.sessionStorage;
    }
}

