/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.support;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.renderer.RenderContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import java.util.Locale;
import org.randombits.confluence.support.RequestInfo;
import org.randombits.storage.Storage;
import org.randombits.storage.confluence.ContentPropertyStorage;
import org.randombits.storage.confluence.RenderContextStorage;

public class PageInfo
extends RequestInfo {
    protected ContentEntityObject content;
    private Storage contentProperties;
    protected PageContext pageCtx;
    private RenderContextStorage ctxParams;
    private Locale userLocale;
    private LocaleManager localeManager;

    public ContentEntityObject getContent() {
        return this.content;
    }

    public Storage getContentProperties() {
        if (this.contentProperties == null && this.content != null) {
            this.contentProperties = new ContentPropertyStorage(this.getContent());
        }
        return this.contentProperties;
    }

    public Storage getRenderContextParams() {
        if (this.ctxParams == null) {
            this.ctxParams = new RenderContextStorage((RenderContext)this.getPageContext());
        }
        return this.ctxParams;
    }

    public PageContext getPageContext() {
        return this.pageCtx;
    }

    public Space getSpace() {
        ContentEntityObject content = this.getContent();
        if (content instanceof SpaceContentEntityObject) {
            return ((SpaceContentEntityObject)content).getSpace();
        }
        return null;
    }

    public User getCurrentUser() {
        return AuthenticatedUserThreadLocal.getUser();
    }

    public Locale getLocale() {
        if (this.userLocale == null) {
            LocaleManager localeManager = this.getLocaleManager();
            this.userLocale = localeManager == null ? LocaleManager.DEFAULT_LOCALE : localeManager.getLocale(this.getCurrentUser());
        }
        return this.userLocale;
    }

    private LocaleManager getLocaleManager() {
        if (this.localeManager == null) {
            this.localeManager = (LocaleManager)ContainerManager.getComponent((String)"localeManager");
        }
        return this.localeManager;
    }
}

