/*
 * Decompiled with CFR 0.152.
 */
package net.customware.confluence.reporting.macro;

import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.Comparator;
import net.customware.confluence.reporting.ReportBuilder;
import net.customware.confluence.reporting.ReportException;
import net.customware.confluence.reporting.Sortable;
import net.customware.confluence.reporting.macro.AbstractReportingMacro;
import net.customware.confluence.reporting.supplier.SupplierValueComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.randombits.confluence.support.MacroInfo;
import org.randombits.storage.IndexedStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSortMacro<V>
extends AbstractReportingMacro {
    private static final String KEY_PARAM = "key";
    private static final String ORDER_PARAM = "order";
    private static final String ASC_ORDER = "asc";
    private static final String DESC_ORDER = "desc";
    private static final String RENDER_PARAM = "render";
    private static final String WIKI_RENDER = "wiki";

    @Override
    protected String report(MacroInfo info) throws MacroException, ReportException {
        Sortable<?> sortable = ReportBuilder.getSortable();
        if (sortable == null) {
            throw new MacroException("This macro must be used in a sortable location, such as a reporter macro.");
        }
        IndexedStorage params = info.getMacroParams();
        String key = params.getString(KEY_PARAM, params.getString(0, null));
        boolean renderWiki = WIKI_RENDER.equals(params.getString(RENDER_PARAM, null));
        Comparator<V> comparator = this.createComparator(info);
        if (comparator != null) {
            Comparator supplierComparator = new SupplierValueComparator(key, comparator, renderWiki);
            if (params.getString(ORDER_PARAM, ASC_ORDER).toLowerCase().startsWith(DESC_ORDER)) {
                supplierComparator = new ReverseComparator(supplierComparator);
            }
            sortable.addComparator(supplierComparator);
            return "";
        }
        throw new MacroException("No comparator was created.");
    }

    protected abstract Comparator<V> createComparator(MacroInfo var1) throws MacroException, ReportException;

    public boolean isInline() {
        return false;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }
}

