/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflowreports.ActivityManager;
import com.comalatech.confluence.workflowreports.CsvExportService;
import com.comalatech.confluence.workflowreports.model.ActivityReportEntry;
import com.comalatech.confluence.workflowreports.model.ActivityReportOptions;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvConfig;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvService;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvServiceImpl;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageActivityExportAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(PageActivityExportAction.class);
    private String reportFilePath;
    private long pageId;
    private String type = "csv";
    private AbstractPage page;
    private String outputText;
    private ActivityManager activityManager;
    private PageManager pageManager;
    private WorkflowPermissionManager workflowPermissionManager;
    private PageActivityCsvService pageActivityCsvService;
    private CsvExportService csvExportService;

    public String execute() throws Exception {
        this.page = this.pageManager.getAbstractPage(this.pageId);
        if (this.page == null || !this.workflowPermissionManager.canViewDrafts(this.page, AuthenticatedUserThreadLocal.get())) {
            return "error";
        }
        ActivityReportOptions exportOptions = new ActivityReportOptions(false, false, false, false, false, false, Integer.MAX_VALUE);
        List<ActivityReportEntry> activityReportEntries = this.activityManager.getActivityReport(this.page, exportOptions);
        this.outputText = this.pageActivityCsvService.getPageActivityFileContent(activityReportEntries, this.page, PageActivityCsvConfig.builder().skipOtherVersion(false).build());
        if (this.type.equals("csvtext")) {
            return "csvtext";
        }
        this.reportFilePath = this.csvExportService.export(this.outputText, this.page);
        log.debug("Generated page workflow csv report: " + this.reportFilePath);
        return "success";
    }

    public String getOutputText() {
        return this.outputText;
    }

    public String getReportFilePath() {
        return this.reportFilePath;
    }

    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setActivityManager(ActivityManager activityManager) {
        this.activityManager = activityManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setWorkflowPermissionManager(WorkflowPermissionManager workflowPermissionManager) {
        this.workflowPermissionManager = workflowPermissionManager;
    }

    public void setPageActivityCsvService(PageActivityCsvServiceImpl pageActivityCsvService) {
        this.pageActivityCsvService = pageActivityCsvService;
    }

    public void setCsvExportService(CsvExportService csvExportService) {
        this.csvExportService = csvExportService;
    }
}

