/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.model;

import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import com.webcohesion.enunciate.metadata.DocumentationExample;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Condition {
    public String clause;

    public Condition() {
    }

    public Condition(String clause) {
        this.clause = clause;
    }

    public static Condition build(SerializableMacro.ParsedParameters params) {
        if (params.has("user")) {
            if (params.not) {
                return new UserCondition(params.value, "is-not");
            }
            return new UserCondition(params.value, "is");
        }
        if (params.has("group")) {
            if (params.not) {
                return new GroupCondition(params.value, "is-not");
            }
            return new GroupCondition(params.value, "is");
        }
        if (params.has("allowedassignusers")) {
            if (params.not) {
                return new AllowedAssignerUserCondition(params.value, "is-not");
            }
            return new AllowedAssignerUserCondition(params.value, "is");
        }
        if (params.has("allowedassigngroups")) {
            if (params.not) {
                return new AllowedAssignerGroupCondition(params.value, "is-not");
            }
            return new AllowedAssignerGroupCondition(params.value, "is");
        }
        if (params.has("exclude")) {
            if (params.not) {
                return new ExcludeCondition(params.value, "is-not");
            }
            return new ExcludeCondition(params.value, "is");
        }
        if (params.has("hasapproval")) {
            if (params.not) {
                return new HasApprovalCondition(params.value, "has-not", true);
            }
            return new HasApprovalCondition(params.value, "has", true);
        }
        if (params.has("hadapproval")) {
            if (params.not) {
                return new HasApprovalCondition(params.value, "had-not", false);
            }
            return new HasApprovalCondition(params.value, "had", false);
        }
        if (params.has("haslabel")) {
            if (params.not) {
                return new HasLabelCondition(params.value, "has-not");
            }
            return new HasLabelCondition(params.value, "has");
        }
        if (params.has("parenthaslabel")) {
            if (params.not) {
                return new HasLabelCondition(params.value, "parent-has-not");
            }
            return new HasLabelCondition(params.value, "parent-has");
        }
        if (params.has("state")) {
            if (params.not) {
                return new StateCondition(params.value, "is-not");
            }
            return new StateCondition(params.value, "is");
        }
        if (params.has("stateindraft")) {
            if (params.not) {
                return new StateCondition(params.value, "state-in-draft-is-not");
            }
            return new StateCondition(params.value, "state-in-draft-is");
        }
        if (params.has("pendingtasks")) {
            if (params.not) {
                return new Condition("has-not-tasks");
            }
            return new Condition("has-tasks");
        }
        if (params.has("isassignment")) {
            if (params.not) {
                return new Condition("is-not-assignment");
            }
            return new Condition("is-assignment");
        }
        if (params.has("ischildof")) {
            if (params.not) {
                return new PageCondition(params.value, "is-not-child");
            }
            return new PageCondition(params.value, "is-child");
        }
        if (params.has("title")) {
            if (params.not) {
                return new PageCondition(params.value, "is-not-title");
            }
            return new PageCondition(params.value, "is-title");
        }
        if (params.has("ishomepage")) {
            if (params.not) {
                return new Condition("is-not-home");
            }
            return new Condition("is-home");
        }
        if (params.has("isminorchange")) {
            if (params.not) {
                return new Condition("is-not-minor");
            }
            return new Condition("is-minor");
        }
        if (params.has("isorphan")) {
            if (params.not) {
                return new Condition("is-not-orphan");
            }
            return new Condition("is-orphan");
        }
        if (params.has("spacekey")) {
            if (params.not) {
                return new SpaceCondition(params.value, "is-not");
            }
            return new SpaceCondition(params.value, "is");
        }
        if (params.has("usersdefined")) {
            if (params.not) {
                return new MetadataCondition(params.value, "is-not-user");
            }
            return new MetadataCondition(params.value, "is-user");
        }
        if (params.has("permission")) {
            if (params.not) {
                return new PermissionCondition(params.value.toLowerCase(), "has-not");
            }
            return new PermissionCondition(params.value.toLowerCase(), "has");
        }
        if (params.isMetadata()) {
            if (params.not) {
                if (params.greaterThan) {
                    return new MetadataCondition(params.metadataName, "is-not-greaterthan", params.value);
                }
                if (params.lessThan) {
                    return new MetadataCondition(params.metadataName, "is-not-lessthan", params.value);
                }
                return new MetadataCondition(params.metadataName, "is-not", params.value);
            }
            if (params.greaterThan) {
                return new MetadataCondition(params.metadataName, "is-greaterthan", params.value);
            }
            if (params.lessThan) {
                return new MetadataCondition(params.metadataName, "is-lessthan", params.value);
            }
            return new MetadataCondition(params.metadataName, "is", params.value);
        }
        return null;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class HasLabelCondition
    extends Condition {
        @DocumentationExample(value="label_1", value2="label_2")
        public List<String> labels;

        public HasLabelCondition() {
        }

        public HasLabelCondition(String labels, String clause) {
            super(clause);
            this.labels = Arrays.asList(labels.split(","));
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class HasApprovalCondition
    extends Condition {
        @DocumentationExample(value="Review Approval")
        public String approval;
        public boolean current;

        public HasApprovalCondition() {
        }

        public HasApprovalCondition(String approval, String clause, boolean current) {
            super(clause);
            this.approval = approval;
            this.current = current;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class AllowedAssignerGroupCondition
    extends Condition {
        @DocumentationExample(value="group_1,group_2,group_3")
        public String groups;

        public AllowedAssignerGroupCondition() {
        }

        public AllowedAssignerGroupCondition(String groups, String clause) {
            super(clause);
            this.groups = groups;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class AllowedAssignerUserCondition
    extends Condition {
        @DocumentationExample(value="user_1,user_2,user_3")
        public String users;

        public AllowedAssignerUserCondition() {
        }

        public AllowedAssignerUserCondition(String users, String clause) {
            super(clause);
            this.users = users;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class GroupCondition
    extends Condition {
        @DocumentationExample(value="group_1,group_2,group_3")
        public String groups;

        public GroupCondition() {
        }

        public GroupCondition(String groups, String clause) {
            super(clause);
            this.groups = groups;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ExcludeCondition
    extends Condition {
        @DocumentationExample(value="user_1,user_2,user_3")
        public String excludedUsers;

        public ExcludeCondition() {
        }

        public ExcludeCondition(String excludedUsers, String clause) {
            super(clause);
            this.excludedUsers = excludedUsers;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class UserCondition
    extends Condition {
        @DocumentationExample(value="user_1,user_2,user_3")
        public String users;

        public UserCondition() {
        }

        public UserCondition(String users, String clause) {
            super(clause);
            this.users = users;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class PageCondition
    extends Condition {
        @DocumentationExample(value="Page 1")
        public String page;

        public PageCondition() {
        }

        public PageCondition(String page, String clause) {
            super(clause);
            this.page = page;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class SpaceCondition
    extends Condition {
        @DocumentationExample(value="SP1")
        public String spaceKey;

        public SpaceCondition() {
        }

        public SpaceCondition(String spaceKey, String clause) {
            super(clause);
            this.spaceKey = spaceKey;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class StateCondition
    extends Condition {
        @DocumentationExample(value="state_1", value2="state_2")
        public List<String> states;

        public StateCondition() {
        }

        public StateCondition(String states, String clause) {
            super(clause);
            this.states = Arrays.asList(states.split(","));
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class MetadataCondition
    extends Condition {
        @DocumentationExample(value="Editor in Chief", value2="Reviewer")
        public List<String> names;
        public String value;

        public MetadataCondition() {
        }

        public MetadataCondition(String valueName, String clause) {
            super(clause);
            this.names = Arrays.asList(valueName.split(","));
        }

        public MetadataCondition(String valueName, String clause, String value) {
            this(valueName, clause);
            this.value = value;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class PermissionCondition
    extends Condition {
        @DocumentationExample(value="edit", value2="view")
        public List<String> permission;

        public PermissionCondition() {
        }

        public PermissionCondition(String permissions, String clause) {
            super(clause);
            this.permission = Arrays.asList(permissions.split(","));
        }
    }
}

