/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.analytics.usecases.eventsusage.listener;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.states.event.BlogPostStateTransitionEvent;
import com.comalatech.confluence.states.event.PageStateTransitionEvent;
import com.comalatech.confluence.states.event.StateExpireEvent;
import com.comalatech.confluence.states.event.StateExpiryUpdatedEvent;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.analytics.usecases.eventsusage.contracts.EventCounterManager;
import org.springframework.beans.factory.annotation.Qualifier;

public class StateEventsAnalyticsListener
extends WorkflowsListener {
    private final EventCounterManager stateEventCounterUseCase;
    private final EventCounterManager totalEventCounterUseCase;

    public StateEventsAnalyticsListener(EventPublisher eventPublisher, @Qualifier(value="stateEventCounterUseCase") EventCounterManager stateEventCounterUseCase, @Qualifier(value="totalEventCounterUseCase") EventCounterManager totalEventCounterUseCase) {
        super(eventPublisher);
        this.stateEventCounterUseCase = stateEventCounterUseCase;
        this.totalEventCounterUseCase = totalEventCounterUseCase;
    }

    @EventListener
    public void onStateExpireEvent(StateExpireEvent event) {
        this.incrementCounters();
    }

    @EventListener
    public void onStateExpiryUpdatedEvent(StateExpiryUpdatedEvent event) {
        this.incrementCounters();
    }

    @EventListener
    public void onPageStateTransitionEvent(PageStateTransitionEvent event) {
        this.incrementCounters();
    }

    @EventListener
    public void onBlogPostStateTransitionEvent(BlogPostStateTransitionEvent event) {
        this.incrementCounters();
    }

    private void incrementCounters() {
        this.totalEventCounterUseCase.increment();
        this.stateEventCounterUseCase.increment();
    }
}

